/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.ThreatIndicator;
import rs.co.ast.aspen.gui.module.threats.DatabaseEvent;
import rs.co.ast.aspen.gui.module.threats.DatabaseEventListener;

public class InMemoryDatabase {
    private static final String DB_CONNECTION = "jdbc:h2:mem:threats;DATABASE_TO_UPPER=false;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE";
    private static final String DB_DRIVER = "org.h2.Driver";
    private static final String DB_PASSWORD = "";
    private static final String DB_USER = "";
    private static final String TABLE_NAME = "threats";
    private static final String DEFAULT_VIEW_QUERY = "SELECT * FROM threats";
    private static final int FILTER_MINIMUM_CHARS = 3;
    private static final String VIEW_NAME = "threats_filter_view";
    private static final Logger logger = Logger.getLogger(InMemoryDatabase.class.getName());
    private List<String> columns = new ArrayList<String>();
    private EventListenerList listeners = new EventListenerList();
    private final SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public synchronized void addDatabaseEventListener(DatabaseEventListener listener) {
        this.listeners.add(DatabaseEventListener.class, listener);
    }

    public synchronized void dispose() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("TRUNCATE TABLE threats");
        }
        catch (SQLException ex) {
            logger.warning(ex.getMessage());
        }
    }

    public synchronized List<Map<String, String>> executeCountQuery(List<String> columnNames) {
        ArrayList rows = null;
        StringBuilder sb = new StringBuilder();
        for (String col : columnNames) {
            if (col.startsWith("func.")) continue;
            sb.append("\"");
            sb.append(col);
            sb.append("\"");
            sb.append(",");
        }
        sb.append(";");
        String query = sb.toString().replace(",;", "");
        try (Connection connection = this.getDBConnection();){
            try (Statement stmt = connection.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT " + query + ", count(*) AS \"func.count\" FROM " + VIEW_NAME + " GROUP BY " + query);
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                rows = new ArrayList();
                while (rs.next()) {
                    HashMap<String, String> row = new HashMap<String, String>();
                    for (int i = 1; i <= columnCount; ++i) {
                        row.put(metaData.getColumnLabel(i), rs.getString(i));
                    }
                    rows.add(row);
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireFunctionQueryExecutedEvent();
        return rows;
    }

    public synchronized void filter(String filter) {
        if (filter.length() >= 3) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM threats WHERE ");
            for (String column : this.columns) {
                query.append("\"");
                query.append(column);
                query.append("\"");
                query.append(" LIKE ");
                query.append("'%");
                query.append(filter);
                query.append("%' OR ");
            }
            query.append(";");
            String q = query.toString().replace(" OR ;", "");
            this.createView(q);
        } else {
            this.createView(DEFAULT_VIEW_QUERY);
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getRowCount() {
        int count = 0;
        try {
            try (Connection connection = this.getDBConnection();){
                try (Statement stmt = connection.createStatement();){
                    ResultSet rs = stmt.executeQuery("SELECT count(*) FROM threats_filter_view");
                    rs.next();
                    count = rs.getInt(1);
                    return count;
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return count;
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        finally {
            return count;
        }
    }

    public synchronized void initDB(final List<ThreatIndicator> threatIndicators, final List<String> pColumns) {
        if (!threatIndicators.isEmpty() && !pColumns.isEmpty()) {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    InMemoryDatabase.this.columns = pColumns;
                    InMemoryDatabase.this.createTable(InMemoryDatabase.this.columns);
                    InMemoryDatabase.this.insertData(threatIndicators, InMemoryDatabase.this.columns);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        InMemoryDatabase.this.fireDataInsertedEvent();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            worker.execute();
        }
    }

    public Map<String, String> selectSpecificRow(int rowIndex) {
        rowIndex = rowIndex == 0 ? 0 : rowIndex;
        HashMap<String, String> row = new HashMap<String, String>();
        try (Connection connection = this.getDBConnection();
             PreparedStatement pstmt = connection.prepareStatement("SELECT * FROM threats_filter_view LIMIT 1 OFFSET ?");){
            pstmt.setInt(1, rowIndex);
            ResultSet rs = pstmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                row = new HashMap();
                for (int i = 1; i <= columnCount; ++i) {
                    row.put(metaData.getColumnLabel(i), rs.getString(i));
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return row;
    }

    private synchronized void createTable(List<String> columnNames) {
        this.dropView();
        this.dropDatabase();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE threats (");
        sb.append("id int auto_increment primary key,");
        for (String col : columnNames) {
            sb.append("\"");
            sb.append(col);
            sb.append("\"");
            sb.append(" text,");
        }
        sb.append(");");
        String query = sb.toString().replace(",);", ");");
        try (Connection connection = this.getDBConnection();
             PreparedStatement prepareStatement = connection.prepareStatement(query);){
            prepareStatement.executeUpdate();
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void createView(String query) {
        this.dropView();
        String q = "CREATE VIEW threats_filter_view AS " + query;
        try (Connection connection = this.getDBConnection();){
            Statement statement = connection.createStatement();
            int ret = statement.executeUpdate(q);
            logger.info(String.format("ROWS CHANGED: %d", ret));
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void dropDatabase() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("DROP TABLE IF EXISTS threats");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void dropView() {
        try (Connection connection = this.getDBConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("DROP VIEW IF EXISTS threats_filter_view");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void fireDataInsertedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).dataInserted(event);
        }
    }

    private synchronized void fireFunctionQueryExecutedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).functionQueryExecuted(event);
        }
    }

    private synchronized void fireTableCreatedEvent() {
        DatabaseEvent event = new DatabaseEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = 0; i < list.length; i += 2) {
            if (list[i] != DatabaseEventListener.class) continue;
            ((DatabaseEventListener)list[i + 1]).tableCreated(event);
        }
    }

    private synchronized Connection getDBConnection() {
        Connection dbConnection = null;
        try {
            Class.forName(DB_DRIVER);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            dbConnection = DriverManager.getConnection(DB_CONNECTION, "", "");
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return dbConnection;
    }

    private synchronized void insertData(List<ThreatIndicator> tiList, List<String> columns) {
        try (Connection connection = this.getDBConnection();){
            try {
                int i;
                connection.setAutoCommit(false);
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO threats (");
                for (i = 0; i < columns.size(); ++i) {
                    if (i == columns.size() - 1) {
                        sb.append("\"");
                        sb.append(columns.get(i));
                        sb.append("\"");
                        continue;
                    }
                    sb.append("\"");
                    sb.append(columns.get(i));
                    sb.append("\"");
                    sb.append(",");
                }
                sb.append(") VALUES (");
                for (i = 0; i < columns.size(); ++i) {
                    if (i == columns.size() - 1) {
                        sb.append("?");
                        continue;
                    }
                    sb.append("?,");
                }
                sb.append(");");
                try (PreparedStatement pstmt = connection.prepareStatement(sb.toString(), columns.toArray(new String[columns.size() - 1]));){
                    for (int i2 = 0; i2 < tiList.size(); ++i2) {
                        ThreatIndicator ti = tiList.get(i2);
                        block37: for (int j = 0; j < columns.size(); ++j) {
                            switch (j) {
                                case 0: {
                                    pstmt.setString(j + 1, ti.getId() != null ? ti.getId() : "");
                                    continue block37;
                                }
                                case 1: {
                                    pstmt.setString(j + 1, ti.getType() != null ? ti.getType().value() : "");
                                    continue block37;
                                }
                                case 2: {
                                    pstmt.setString(j + 1, ti.getConfidenceLevel() != null ? ti.getConfidenceLevel().value() : "");
                                    continue block37;
                                }
                                case 3: {
                                    pstmt.setString(j + 1, ti.getDescription() != null ? ti.getDescription() : "");
                                    continue block37;
                                }
                                case 4: {
                                    pstmt.setString(j + 1, this.smf.format(ti.getCreated()));
                                    continue block37;
                                }
                                case 5: {
                                    pstmt.setString(j + 1, this.smf.format(ti.getLastUpdated()));
                                    continue block37;
                                }
                                case 6: {
                                    pstmt.setString(j + 1, ti.getSources().isEmpty() ? "" : ti.getSources().stream().collect(Collectors.joining(";")));
                                    continue block37;
                                }
                                case 7: {
                                    pstmt.setString(j + 1, ti.getTags().isEmpty() ? "" : ti.getTags().stream().collect(Collectors.joining(";")));
                                }
                            }
                        }
                        pstmt.executeUpdate();
                    }
                }
                connection.commit();
                this.createView(DEFAULT_VIEW_QUERY);
            }
            catch (SQLException ex) {
                try {
                    connection.rollback();
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SQLException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

