/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.model.DeletedDataMapsModel;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapKeyChildFactory;
import rs.co.ast.aspen.gui.module.datamaps.nodes.RootNode;

public class DataMapNode
extends AbstractNode
implements PropertyChangeListener,
NodeListener,
Comparable<DataMapNode> {
    private DeletedDataMapsModel deletedDataMapsModel = (DeletedDataMapsModel)Lookup.getDefault().lookup(DeletedDataMapsModel.class);
    private DataMapName dataMapName;
    private String regex;

    public DataMapNode(DataMapName dataMapName, String regex) {
        super(Children.create((ChildFactory)new DataMapKeyChildFactory(dataMapName.getName(), regex), (boolean)true), Lookups.singleton((Object)dataMapName));
        this.dataMapName = dataMapName;
        this.regex = regex;
        this.setDisplayName(dataMapName.getName());
        if (dataMapName.hasData()) {
            this.setIconBaseWithExtension("datamap_green.png");
        } else {
            this.setIconBaseWithExtension("datamap_empty.png");
        }
        this.addNodeListener(this);
        this.addPropertyChangeListener(this);
    }

    public String getHtmlDisplayName() {
        String name = this.dataMapName.getName();
        if (this.deletedDataMapsModel.findMap(name)) {
            name = "<html><s><i>" + name + "</i></s></html>";
        }
        return name;
    }

    public DataMapName getDataMapName() {
        return this.dataMapName;
    }

    public void updateChildren(String dataMapName, String regex) {
        this.setChildren(Children.create((ChildFactory)new DataMapKeyChildFactory(dataMapName, regex), (boolean)true));
    }

    public boolean canDestroy() {
        return true;
    }

    public Action[] getActions(boolean context) {
        int size = Utilities.actionsForPath((String)"Actions/RightClickDataMap").size();
        Action[] actions = new Action[size];
        for (int i = 0; i < size; ++i) {
            actions[i] = (Action)Utilities.actionsForPath((String)"Actions/RightClickDataMap").get(i);
        }
        return actions;
    }

    public void destroy() throws IOException {
        this.fireNodeDestroyed();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void nodeDestroyed(NodeEvent ne) {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof RootNode) {
            RootNode node = (RootNode)parentNode;
            node.updateChildren(this.regex);
        }
    }

    @Override
    public int compareTo(DataMapNode o) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.dataMapName.getName(), o.getDataMapName().getName());
    }
}

