/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.gui.module.datamaps.DataMapDataSource;
import rs.co.ast.aspen.gui.module.datamaps.DataMapsTopComponent;
import rs.co.ast.aspen.gui.module.datamaps.ExportHelper;
import rs.co.ast.aspen.gui.module.datamaps.ProgressValueChangedEvent;
import rs.co.ast.aspen.gui.module.datamaps.ReportDataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.UniqueFildsPreferences;

public class ExportGenerator
implements Runnable {
    private static final Logger logger = Logger.getLogger(ExportGenerator.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private String mapName;
    private List<String> fields = new ArrayList<String>();
    private boolean useMultipleWorkSheets;
    private ProgressValueChangedEvent.ProgressValueChangedListener listener;
    private ExportType type;
    private List<ReportDataMapKey> dataMapKeys;
    private String separator;
    private Map<WorkFinishedListener, Object> workDoneListeners = new WeakHashMap<WorkFinishedListener, Object>();

    public ExportGenerator(String mapName, List<String> fields, boolean useMultipleWorkSheets) {
        this.mapName = mapName;
        this.type = ExportType.EXCEL;
        this.fields = fields;
        this.useMultipleWorkSheets = useMultipleWorkSheets;
    }

    public ExportGenerator(String mapName, List<String> fields, String separator) {
        this.mapName = mapName;
        this.type = ExportType.CSV;
        this.fields = fields;
        this.separator = separator;
    }

    public ExportGenerator(String mapName) {
        this.mapName = mapName;
        this.type = ExportType.JSON;
    }

    @Override
    public void run() {
        switch (this.type) {
            case EXCEL: {
                this.doItExcel();
                break;
            }
            case JSON: {
                this.doItJson();
                break;
            }
            case CSV: {
                this.doItCsv();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doItExcel() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.export_progress.title"));
        try {
            ph.start();
            DataMapDataSource ds = new DataMapDataSource(this.mapName, this.listener, true);
            List<String> uniqueFields = ExportHelper.getAllUniqueFields(ds.getDataMapKeys());
            UniqueFildsPreferences ufp = new UniqueFildsPreferences();
            ufp.saveUniqueFields(uniqueFields);
            HSSFWorkbook wbtmp = null;
            wbtmp = this.useMultipleWorkSheets ? ExportHelper.makeExcelMultiSheetDocument(this.mapName, ds.getDataMapKeys(), this.fields) : ExportHelper.makeExcelDocument(this.mapName, ds.getDataMapKeys(), this.fields);
            final HSSFWorkbook wb = wbtmp;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String fileName = ExportGenerator.this.genFileName();
                    JFileChooser saveDialog = new JFileChooser();
                    saveDialog.setDialogTitle(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.title"));
                    saveDialog.setDialogType(1);
                    saveDialog.setSelectedFile(new File(fileName));
                    int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                    if (actionDialog == 0) {
                        try {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            byte[] file = null;
                            try (FileOutputStream fileOuputStream = new FileOutputStream(dfile);){
                                wb.write((OutputStream)fileOuputStream);
                            }
                            ExportGenerator.this.fireWorkFinishedEvent(fileName, file, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            ExportGenerator.this.fireWorkFinishedEvent(null, null, false);
                        }
                        finally {
                            ph.finish();
                        }
                    } else {
                        ph.finish();
                    }
                }
            });
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doItJson() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.export_progress.title"));
        try {
            ph.start();
            try {
                this.dataMapKeys = new ArrayList<ReportDataMapKey>();
                List keysForDataMap = this.apiService.getKeysForDataMap(this.mapName);
                for (String key : keysForDataMap) {
                    DataMapValue value = this.apiService.getValueForDataMapKey(this.mapName, key);
                    this.dataMapKeys.add(new ReportDataMapKey(key, value.getValue()));
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            final String json = ExportHelper.hashMap2Json(this.dataMapKeys);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String fileName = ExportGenerator.this.genFileName();
                    JFileChooser saveDialog = new JFileChooser();
                    saveDialog.setDialogTitle(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.title"));
                    saveDialog.setDialogType(1);
                    saveDialog.setSelectedFile(new File(fileName));
                    int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                    if (actionDialog == 0) {
                        try {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            byte[] file = null;
                            try (FileWriter fw = new FileWriter(dfile);){
                                fw.write(json);
                            }
                            ExportGenerator.this.fireWorkFinishedEvent(fileName, file, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            ExportGenerator.this.fireWorkFinishedEvent(null, null, false);
                        }
                        finally {
                            ph.finish();
                        }
                    } else {
                        ph.finish();
                    }
                }
            });
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doItCsv() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.export_progress.title"));
        try {
            ph.start();
            DataMapDataSource ds = new DataMapDataSource(this.mapName, this.listener, true);
            List<String> uniqueFields = ExportHelper.getAllUniqueFields(ds.getDataMapKeys());
            UniqueFildsPreferences ufp = new UniqueFildsPreferences();
            ufp.saveUniqueFields(uniqueFields);
            final StringBuffer stringBuffer = ExportHelper.makeCsvDocument(this.mapName, ds.getDataMapKeys(), this.fields, this.separator);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String fileName = ExportGenerator.this.genFileName();
                    JFileChooser saveDialog = new JFileChooser();
                    saveDialog.setDialogTitle(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.title"));
                    saveDialog.setDialogType(1);
                    saveDialog.setSelectedFile(new File(fileName));
                    int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                    if (actionDialog == 0) {
                        try {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            byte[] file = null;
                            try (FileWriter fw = new FileWriter(dfile);){
                                fw.write(stringBuffer.toString());
                            }
                            ExportGenerator.this.fireWorkFinishedEvent(fileName, file, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            ExportGenerator.this.fireWorkFinishedEvent(null, null, false);
                        }
                        finally {
                            ph.finish();
                        }
                    } else {
                        ph.finish();
                    }
                }
            });
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
        }
    }

    private String genFileName() {
        DateTime now = new DateTime();
        DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
        String ext = "";
        switch (this.type) {
            case EXCEL: {
                ext = "xls";
                break;
            }
            case JSON: {
                ext = "json";
                break;
            }
            case CSV: {
                ext = "csv";
            }
        }
        return String.format("%s%s_%s.%s", NbBundle.getMessage(DataMapDataSource.class, (String)"ExportGenerator.fileName"), this.mapName, now.toString(dtf), ext);
    }

    public void addWorkFinishedListener(WorkFinishedListener listener) {
        this.workDoneListeners.put(listener, null);
    }

    public void removeWorkFinishedListener(WorkFinishedListener listener) {
        this.workDoneListeners.remove(listener);
    }

    private void fireWorkFinishedEvent(String fileName, byte[] file, Boolean success) {
        WorkFinishedEvent event = new WorkFinishedEvent();
        for (WorkFinishedListener l : this.workDoneListeners.keySet()) {
            l.done(event, fileName, file, success);
        }
    }

    public class WorkFinishedEvent {
    }

    public static interface WorkFinishedListener {
        public void done(WorkFinishedEvent var1, String var2, byte[] var3, Boolean var4);
    }

    public static enum ExportType {
        EXCEL,
        JSON,
        CSV;

    }
}

