/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.oggtools;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.UncachedUrlStream;
import de.jarnbjo.vorbis.VorbisStream;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class TinyPlayerApplet
extends Applet
implements Runnable {
    private boolean running = false;
    private boolean initialized = false;
    private VorbisStream vStream;
    private LogicalOggStream loStream;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public void init() {
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        try {
            String url = this.getParameter("url");
            try {
                VorbisStream vs;
                this.running = true;
                UncachedUrlStream os = new UncachedUrlStream(new URL(this.getCodeBase(), url));
                LogicalOggStream los = (LogicalOggStream)os.getLogicalStreams().iterator().next();
                this.vStream = vs = new VorbisStream(los);
                this.loStream = los;
                this.initialized = true;
                AudioFormat audioFormat = new AudioFormat(vs.getIdentificationHeader().getSampleRate(), 16, vs.getIdentificationHeader().getChannels(), true, true);
                DataLine.Info dataLineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = TinyPlayerApplet.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
                SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                sourceDataLine.open(audioFormat);
                sourceDataLine.start();
                VorbisInputStream vis = new VorbisInputStream(vs);
                AudioInputStream ais = new AudioInputStream(vis, audioFormat, -1L);
                byte[] buffer = new byte[4096];
                int cnt = 0;
                int offset = 0;
                int total = 0;
                long sampleRate = vs.getIdentificationHeader().getSampleRate();
                long oldLt = 0L;
                while (this.running) {
                    for (offset = 0; offset < buffer.length && (cnt = ais.read(buffer, offset, buffer.length - offset)) > 0; offset += cnt) {
                    }
                    if (cnt == -1) {
                        this.running = false;
                    }
                    if (offset > 0) {
                        sourceDataLine.write(buffer, 0, offset);
                        total += offset;
                    }
                    offset = 0;
                    cnt = 0;
                }
                sourceDataLine.drain();
                sourceDataLine.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;
        private static int cnt = 0;

        public VorbisInputStream(VorbisStream source) {
            this.source = source;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.source.readPcm(buffer, offset, length);
            }
            catch (EndOfOggStreamException e) {
                return -1;
            }
        }
    }
}

