/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort.actions;

import java.util.List;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.sort.actions.AddSortFieldCommand;
import net.sf.jasperreports.components.sort.actions.RemoveSortFieldCommand;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;

public class SortCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CREATE_SORT_FIELDS_FOR_GROUPS = "net.sf.jasperreports.create.sort.fields.for.groups";
    private JasperReportsContext jasperReportsContext;
    protected JRDesignDataset dataset;
    protected SortData sortData;
    private CommandStack individualCommandStack;

    public SortCommand(JasperReportsContext jasperReportsContext, JRDesignDataset dataset, SortData sortData) {
        this.jasperReportsContext = jasperReportsContext;
        this.dataset = dataset;
        this.sortData = sortData;
        this.individualCommandStack = new CommandStack();
    }

    @Override
    public void execute() throws CommandException {
        SortOrderEnum sortOrder = HeaderToolbarElementUtils.getSortOrder(this.sortData.getSortOrder());
        JRDesignSortField newSortField = new JRDesignSortField(this.sortData.getSortColumnName(), SortFieldTypeEnum.getByName(this.sortData.getSortColumnType()), sortOrder);
        JRSortField oldSortField = null;
        List<JRSortField> sortFields = this.dataset.getSortFieldsList();
        if (JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.dataset, PROPERTY_CREATE_SORT_FIELDS_FOR_GROUPS, false) && (sortFields == null || sortFields.isEmpty())) {
            List<JRGroup> groups = this.dataset.getGroupsList();
            for (JRGroup group : groups) {
                JRExpressionChunk chunk;
                JRExpressionChunk[] chunks;
                JRExpression expression = group.getExpression();
                if (expression == null || (chunks = expression.getChunks()) == null || chunks.length != 1 || (chunk = chunks[0]).getType() != 3 && chunk.getType() != 4) continue;
                JRDesignSortField groupSortField = new JRDesignSortField(chunk.getText(), chunk.getType() == 3 ? SortFieldTypeEnum.FIELD : SortFieldTypeEnum.VARIABLE, SortOrderEnum.ASCENDING);
                this.individualCommandStack.execute(new AddSortFieldCommand(this.dataset, groupSortField));
            }
        }
        for (JRSortField crtSortField : sortFields) {
            if (!newSortField.getName().equals(crtSortField.getName()) || newSortField.getType() != crtSortField.getType()) continue;
            oldSortField = crtSortField;
            break;
        }
        if (oldSortField != null) {
            this.individualCommandStack.execute(new RemoveSortFieldCommand(this.dataset, oldSortField));
        }
        if (sortOrder != null) {
            this.individualCommandStack.execute(new AddSortFieldCommand(this.dataset, newSortField));
        }
    }

    @Override
    public void undo() {
        this.individualCommandStack.undoAll();
    }

    @Override
    public void redo() {
        this.individualCommandStack.redoAll();
    }
}

