/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationManager;

public class Consumer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(Consumer.class.getName());
    private volatile boolean paused = false;
    private final BlockingQueue<List<Node>> queue;
    private final VisualizationManager visManager = (VisualizationManager)Lookup.getDefault().lookup(VisualizationManager.class);

    public Consumer(BlockingQueue<List<Node>> queue) {
        super("Consumer");
        this.queue = queue;
    }

    public void pause() {
        this.paused = true;
        LOGGER.info("Consumer paused.");
    }

    @Override
    public void run() {
        try {
            block7: while (!this.isInterrupted()) {
                Thread.sleep(1L);
                while (!this.paused) {
                    if (this.isInterrupted()) {
                        LOGGER.info("Consumer stopped");
                        continue block7;
                    }
                    List<Node> nodes = this.queue.take();
                    this.visManager.getApp().addNodes(nodes);
                }
            }
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.SEVERE, "Error in consumer", ex);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, "Consumer thread interrupted", ex);
        }
        finally {
            LOGGER.info("Consumer finished.");
        }
    }

    public void unpause() {
        this.paused = false;
        LOGGER.info("Consumer unpaused.");
    }

    public void stopThread() {
        this.interrupt();
    }
}

