/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.logic;

import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;

public final class MultiPassLightingLogic
extends DefaultTechniqueDefLogic {
    private static final RenderState ADDITIVE_LIGHT = new RenderState();
    private static final Quaternion NULL_DIR_LIGHT = new Quaternion(0.0f, -1.0f, 0.0f, -1.0f);
    private final ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);

    public MultiPassLightingLogic(TechniqueDef techniqueDef) {
        super(techniqueDef);
    }

    @Override
    public void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights, int lastTexUnit) {
        Renderer r = renderManager.getRenderer();
        Uniform lightDir = shader.getUniform("g_LightDirection");
        Uniform lightColor = shader.getUniform("g_LightColor");
        Uniform lightPos = shader.getUniform("g_LightPosition");
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        boolean isFirstLight = true;
        boolean isSecondLight = false;
        MultiPassLightingLogic.getAmbientColor(lights, false, this.ambientLightColor);
        for (int i = 0; i < lights.size(); ++i) {
            Light l = lights.get(i);
            if (l instanceof AmbientLight) continue;
            if (isFirstLight) {
                ambientColor.setValue(VarType.Vector4, this.ambientLightColor);
                isFirstLight = false;
                isSecondLight = true;
            } else if (isSecondLight) {
                ambientColor.setValue(VarType.Vector4, ColorRGBA.Black);
                r.applyRenderState(ADDITIVE_LIGHT);
                isSecondLight = false;
            }
            TempVars vars = TempVars.get();
            Quaternion tmpLightDirection = vars.quat1;
            Quaternion tmpLightPosition = vars.quat2;
            ColorRGBA tmpLightColor = vars.color;
            Vector4f tmpVec = vars.vect4f1;
            ColorRGBA color = l.getColor();
            tmpLightColor.set(color);
            tmpLightColor.a = l.getType().getId();
            lightColor.setValue(VarType.Vector4, tmpLightColor);
            switch (l.getType()) {
                case Directional: {
                    DirectionalLight dl = (DirectionalLight)l;
                    Vector3f dir = dl.getDirection();
                    tmpLightPosition.set(dir.getX(), dir.getY(), dir.getZ(), -1.0f);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpLightDirection.set(0.0f, 0.0f, 0.0f, 0.0f);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                case Point: {
                    PointLight pl = (PointLight)l;
                    Vector3f pos = pl.getPosition();
                    float invRadius = pl.getInvRadius();
                    tmpLightPosition.set(pos.getX(), pos.getY(), pos.getZ(), invRadius);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpLightDirection.set(0.0f, 0.0f, 0.0f, 0.0f);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                case Spot: {
                    SpotLight sl = (SpotLight)l;
                    Vector3f pos2 = sl.getPosition();
                    Vector3f dir2 = sl.getDirection();
                    float invRange = sl.getInvSpotRange();
                    float spotAngleCos = sl.getPackedAngleCos();
                    tmpLightPosition.set(pos2.getX(), pos2.getY(), pos2.getZ(), invRange);
                    lightPos.setValue(VarType.Vector4, tmpLightPosition);
                    tmpVec.set(dir2.getX(), dir2.getY(), dir2.getZ(), 0.0f);
                    renderManager.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    tmpLightDirection.set(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), spotAngleCos);
                    lightDir.setValue(VarType.Vector4, tmpLightDirection);
                    break;
                }
                case Probe: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                }
            }
            vars.release();
            r.setShader(shader);
            MultiPassLightingLogic.renderMeshFromGeometry(r, geometry);
        }
        if (isFirstLight) {
            ambientColor.setValue(VarType.Vector4, MultiPassLightingLogic.getAmbientColor(lights, false, this.ambientLightColor));
            lightColor.setValue(VarType.Vector4, ColorRGBA.BlackNoAlpha);
            lightPos.setValue(VarType.Vector4, NULL_DIR_LIGHT);
            r.setShader(shader);
            MultiPassLightingLogic.renderMeshFromGeometry(r, geometry);
        }
    }

    static {
        ADDITIVE_LIGHT.setBlendMode(RenderState.BlendMode.AlphaAdditive);
        ADDITIVE_LIGHT.setDepthWrite(false);
    }
}

