/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapFont;
import com.jme3.font.LetterQuad;
import com.jme3.font.Letters;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

class BitmapTextPage
extends Geometry {
    private final float[] pos;
    private final float[] tc;
    private final short[] idx;
    private final byte[] color;
    private final int page;
    private final Texture2D texture;
    private final LinkedList<LetterQuad> pageQuads = new LinkedList();

    BitmapTextPage(BitmapFont font, boolean arrayBased, int page) {
        super("BitmapFont", new Mesh());
        this.setRequiresUpdates(false);
        this.setBatchHint(Spatial.BatchHint.Never);
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null.");
        }
        this.page = page;
        Material mat = font.getPage(page);
        if (mat == null) {
            throw new IllegalStateException("The font's texture was not found!");
        }
        this.setMaterial(mat);
        this.texture = (Texture2D)mat.getTextureParam("ColorMap").getTextureValue();
        Mesh m = this.getMesh();
        m.setBuffer(VertexBuffer.Type.Position, 3, new float[0]);
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[0]);
        m.setBuffer(VertexBuffer.Type.Color, 4, new byte[0]);
        m.setBuffer(VertexBuffer.Type.Index, 3, new short[0]);
        m.getBuffer(VertexBuffer.Type.Color).setNormalized(true);
        arrayBased = true;
        if (arrayBased) {
            this.pos = new float[12];
            this.tc = new float[8];
            this.idx = new short[6];
            this.color = new byte[16];
        } else {
            this.pos = null;
            this.tc = null;
            this.idx = null;
            this.color = null;
        }
    }

    BitmapTextPage(BitmapFont font, boolean arrayBased) {
        this(font, arrayBased, 0);
    }

    BitmapTextPage(BitmapFont font) {
        this(font, false, 0);
    }

    Texture2D getTexture() {
        return this.texture;
    }

    @Override
    public BitmapTextPage clone() {
        BitmapTextPage clone = (BitmapTextPage)super.clone();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        Mesh originalMesh = this.mesh;
        super.cloneFields(cloner, original);
        if (this.mesh == originalMesh) {
            this.mesh = this.mesh.deepClone();
        }
    }

    void assemble(Letters quads) {
        this.pageQuads.clear();
        quads.rewind();
        while (quads.nextCharacter()) {
            if (!quads.isPrintable() || quads.getCharacterSetPage() != this.page) continue;
            this.pageQuads.add(quads.getQuad());
        }
        Mesh m = this.getMesh();
        int vertCount = this.pageQuads.size() * 4;
        int triCount = this.pageQuads.size() * 2;
        VertexBuffer pb = m.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer tb = m.getBuffer(VertexBuffer.Type.TexCoord);
        VertexBuffer ib = m.getBuffer(VertexBuffer.Type.Index);
        VertexBuffer cb = m.getBuffer(VertexBuffer.Type.Color);
        FloatBuffer fpb = (FloatBuffer)pb.getData();
        FloatBuffer ftb = (FloatBuffer)tb.getData();
        ShortBuffer sib = (ShortBuffer)ib.getData();
        ByteBuffer bcb = (ByteBuffer)cb.getData();
        fpb.rewind();
        fpb = BufferUtils.ensureLargeEnough(fpb, vertCount * 3);
        fpb.limit(vertCount * 3);
        pb.updateData(fpb);
        ftb.rewind();
        ftb = BufferUtils.ensureLargeEnough(ftb, vertCount * 2);
        ftb.limit(vertCount * 2);
        tb.updateData(ftb);
        bcb.rewind();
        bcb = BufferUtils.ensureLargeEnough(bcb, vertCount * 4);
        bcb.limit(vertCount * 4);
        cb.updateData(bcb);
        sib.rewind();
        sib = BufferUtils.ensureLargeEnough(sib, triCount * 3);
        sib.limit(triCount * 3);
        ib.updateData(sib);
        m.updateCounts();
        if (this.pos != null) {
            for (int i = 0; i < this.pageQuads.size(); ++i) {
                LetterQuad fq = this.pageQuads.get(i);
                fq.storeToArrays(this.pos, this.tc, this.idx, this.color, i);
                fpb.put(this.pos);
                ftb.put(this.tc);
                sib.put(this.idx);
                bcb.put(this.color);
            }
        } else {
            for (int i = 0; i < this.pageQuads.size(); ++i) {
                LetterQuad fq = this.pageQuads.get(i);
                fq.appendPositions(fpb);
                fq.appendTexCoords(ftb);
                fq.appendIndices(sib, i);
                fq.appendColors(bcb);
            }
        }
        fpb.rewind();
        ftb.rewind();
        sib.rewind();
        bcb.rewind();
        this.updateModelBound();
    }
}

