/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.effect.shapes;

import com.jme3.effect.shapes.EmitterShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmitterMeshVertexShape
implements EmitterShape {
    protected List<List<Vector3f>> vertices;
    protected List<List<Vector3f>> normals;

    public EmitterMeshVertexShape() {
    }

    public EmitterMeshVertexShape(List<Mesh> meshes) {
        this.setMeshes(meshes);
    }

    public void setMeshes(List<Mesh> meshes) {
        HashMap<Vector3f, Vector3f> vertToNormalMap = new HashMap<Vector3f, Vector3f>();
        this.vertices = new ArrayList<List<Vector3f>>(meshes.size());
        this.normals = new ArrayList<List<Vector3f>>(meshes.size());
        for (Mesh mesh : meshes) {
            float[] vertexTable = BufferUtils.getFloatArray(mesh.getFloatBuffer(VertexBuffer.Type.Position));
            float[] normalTable = BufferUtils.getFloatArray(mesh.getFloatBuffer(VertexBuffer.Type.Normal));
            for (int i = 0; i < vertexTable.length; i += 3) {
                Vector3f vert = new Vector3f(vertexTable[i], vertexTable[i + 1], vertexTable[i + 2]);
                Vector3f norm = (Vector3f)vertToNormalMap.get(vert);
                if (norm == null) {
                    norm = new Vector3f(normalTable[i], normalTable[i + 1], normalTable[i + 2]);
                    vertToNormalMap.put(vert, norm);
                    continue;
                }
                norm.addLocal(normalTable[i], normalTable[i + 1], normalTable[i + 2]);
            }
            ArrayList vertices = new ArrayList(vertToNormalMap.size());
            ArrayList<Vector3f> normals = new ArrayList<Vector3f>(vertToNormalMap.size());
            for (Map.Entry entry : vertToNormalMap.entrySet()) {
                vertices.add(entry.getKey());
                normals.add(((Vector3f)entry.getValue()).normalizeLocal());
            }
            this.vertices.add(vertices);
            this.normals.add(normals);
        }
    }

    @Override
    public void getRandomPoint(Vector3f store) {
        int meshIndex = FastMath.nextRandomInt(0, this.vertices.size() - 1);
        int vertIndex = FastMath.nextRandomInt(0, this.vertices.get(meshIndex).size() - 1);
        store.set(this.vertices.get(meshIndex).get(vertIndex));
    }

    @Override
    public void getRandomPointAndNormal(Vector3f store, Vector3f normal) {
        int meshIndex = FastMath.nextRandomInt(0, this.vertices.size() - 1);
        int vertIndex = FastMath.nextRandomInt(0, this.vertices.get(meshIndex).size() - 1);
        store.set(this.vertices.get(meshIndex).get(vertIndex));
        normal.set(this.normals.get(meshIndex).get(vertIndex));
    }

    @Override
    public EmitterShape deepClone() {
        try {
            ArrayList<Vector3f> vectorList;
            EmitterMeshVertexShape clone = (EmitterMeshVertexShape)super.clone();
            if (this.vertices != null) {
                clone.vertices = new ArrayList<List<Vector3f>>(this.vertices.size());
                for (List<Vector3f> list : this.vertices) {
                    vectorList = new ArrayList<Vector3f>(list.size());
                    for (Vector3f vector : list) {
                        vectorList.add(vector.clone());
                    }
                    clone.vertices.add(vectorList);
                }
            }
            if (this.normals != null) {
                clone.normals = new ArrayList<List<Vector3f>>(this.normals.size());
                for (List<Vector3f> list : this.normals) {
                    vectorList = new ArrayList(list.size());
                    for (Vector3f vector : list) {
                        vectorList.add(vector.clone());
                    }
                    clone.normals.add(vectorList);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.vertices = cloner.clone(this.vertices);
        this.normals = cloner.clone(this.normals);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeSavableArrayList((ArrayList)this.vertices, "vertices", null);
        oc.writeSavableArrayList((ArrayList)this.normals, "normals", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.vertices = ic.readSavableArrayList("vertices", null);
        ArrayList tmpNormals = ic.readSavableArrayList("normals", null);
        if (tmpNormals != null) {
            this.normals = tmpNormals;
        }
    }
}

