/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.gui.module.usermgmt.UsersTableModel;

public class UserTableRenderer
extends JLabel
implements TableCellRenderer {
    private UsersTableModel model = null;

    public UserTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.model == null) {
            this.model = (UsersTableModel)table.getModel();
        }
        ConsoleUser user = (ConsoleUser)value;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else if (user.isDisabled()) {
            this.setForeground(UIManager.getColor("MenuItem.disabledForeground"));
            this.setBackground(table.getBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCelHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        this.setText(user.getId());
        this.setIconTextGap(20);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("user.png"));
        this.setIcon(icon);
        return this;
    }
}

