/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserChangedEvent;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserNode;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserService;

public class UserChildFactory
extends ChildFactory
implements LookupListener {
    private final Lookup.Result<ConsoleUserChangedEvent> lookupResult;

    public UserChildFactory() {
        ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
        this.lookupResult = cus.getLookup().lookupResult(ConsoleUserChangedEvent.class);
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent le) {
        Lookup.Result r = (Lookup.Result)le.getSource();
        Collection c = r.allInstances();
        for (Object o : c) {
            if (!(o instanceof ConsoleUserChangedEvent)) continue;
            this.refresh(true);
        }
    }

    protected boolean createKeys(List toPopulate) {
        boolean ret = false;
        try {
            ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
            List<ConsoleUser> users = cus.getUsers();
            Collections.sort(users, new Comparator<ConsoleUser>(){

                @Override
                public int compare(ConsoleUser o1, ConsoleUser o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            toPopulate.addAll(users);
            ret = true;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret;
    }

    protected Node createNodeForKey(Object key) {
        return new ConsoleUserNode((ConsoleUser)key);
    }
}

