/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionDistLimit
extends ConstraintDefinition {
    private static final int LIMITDIST_INSIDE = 0;
    private static final int LIMITDIST_OUTSIDE = 1;
    private static final int LIMITDIST_ONSURFACE = 2;
    protected int mode;
    protected float dist;

    public ConstraintDefinitionDistLimit(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        this.mode = ((Number)constraintData.getFieldValue("mode")).intValue();
        this.dist = ((Number)constraintData.getFieldValue("dist")).floatValue();
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (this.getOwner() instanceof Bone && ((Bone)this.getOwner()).getParent() != null && this.blenderContext.getBoneContext(this.ownerOMA).is(16)) {
            return;
        }
        if (influence == 0.0f || targetTransform == null) {
            return;
        }
        Transform ownerTransform = this.getOwnerTransform(ownerSpace);
        Vector3f v = ownerTransform.getTranslation().subtract(targetTransform.getTranslation());
        float currentDistance = v.length();
        switch (this.mode) {
            case 0: {
                if (!(currentDistance >= this.dist)) break;
                v.normalizeLocal();
                v.multLocal(this.dist + (currentDistance - this.dist) * (1.0f - influence));
                ownerTransform.getTranslation().set(v.addLocal(targetTransform.getTranslation()));
                break;
            }
            case 2: {
                if (currentDistance > this.dist) {
                    v.normalizeLocal();
                    v.multLocal(this.dist + (currentDistance - this.dist) * (1.0f - influence));
                    ownerTransform.getTranslation().set(v.addLocal(targetTransform.getTranslation()));
                    break;
                }
                if (!(currentDistance < this.dist)) break;
                v.normalizeLocal().multLocal(this.dist * influence);
                ownerTransform.getTranslation().set(targetTransform.getTranslation().add(v));
                break;
            }
            case 1: {
                if (!(currentDistance <= this.dist)) break;
                v = targetTransform.getTranslation().subtract(ownerTransform.getTranslation()).normalizeLocal().multLocal(this.dist * influence);
                ownerTransform.getTranslation().set(targetTransform.getTranslation().add(v));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown distance limit constraint mode: " + this.mode);
            }
        }
        this.applyOwnerTransform(ownerTransform, ownerSpace);
    }

    @Override
    public boolean isTargetRequired() {
        return true;
    }

    @Override
    public String getConstraintTypeName() {
        return "Limit distance";
    }
}

