/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SecurityEvent;

public class SearchResults {
    public static final String PROP_TOTAL_HITS = "PROP_TOTAL_HITS";
    public static final String PROP_TOTAL_DURATION = "PROP_TOTAL_DURATION";
    public static final String PROP_EVENTS = "PROP_EVENTS";
    private PropertyChangeSupport properyChangeSupport = new PropertyChangeSupport(this);
    private AtomicLong totalHits = new AtomicLong(0L);
    private AtomicLong totalDuration = new AtomicLong(0L);
    private List<SecurityEvent> events = Collections.synchronizedList(new ArrayList());
    private Set<String> errors = new HashSet<String>();
    private int pageSize;
    private boolean sortAsc;
    private Map<DateRange, Long> countsByDateRange = new HashMap<DateRange, Long>();
    private boolean accumulateTotalDuration = true;

    public long getTotalHits() {
        return this.totalHits.get();
    }

    public void addToTotalHits(long totalHits) {
        long oldTotalHits = this.totalHits.get();
        this.totalHits.addAndGet(totalHits);
        this.properyChangeSupport.firePropertyChange(PROP_TOTAL_HITS, oldTotalHits, this.totalHits);
    }

    public long getTotalDuration() {
        return this.totalDuration.get();
    }

    public void addToTotalDuration(long totalDuration) {
        if (!this.accumulateTotalDuration) {
            this.totalDuration.set(0L);
        }
        long oldTotalDuration = this.totalDuration.get();
        this.totalDuration.addAndGet(totalDuration);
        this.properyChangeSupport.firePropertyChange(PROP_TOTAL_DURATION, oldTotalDuration, this.totalDuration);
    }

    public List<SecurityEvent> getEvents() {
        return this.events;
    }

    public void addEvents(List<SecurityEvent> events) {
        this.events.addAll(events);
        Collections.sort(this.events, new Comparator<SecurityEvent>(){

            @Override
            public int compare(SecurityEvent o1, SecurityEvent o2) {
                if (SearchResults.this.sortAsc) {
                    return o1.getTimestamp().compareTo(o2.getTimestamp());
                }
                return -1 * o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
        if (this.events.size() > this.pageSize) {
            this.events = this.events.subList(0, this.pageSize);
        }
        this.properyChangeSupport.firePropertyChange(PROP_EVENTS, null, this.events);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void addErrors(List<String> errors) {
        this.errors.addAll(errors);
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isSortAsc() {
        return this.sortAsc;
    }

    public void setSortAsc(boolean sortAsc) {
        this.sortAsc = sortAsc;
    }

    public void setAccumulateTotalDuration(boolean accumulateTotalDuration) {
        this.accumulateTotalDuration = accumulateTotalDuration;
    }

    public Map<DateRange, Long> getCountsByDateRange() {
        return this.countsByDateRange;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.properyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.properyChangeSupport.removePropertyChangeListener(listener);
    }
}

