/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.GroupLayout;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsFullScreenPanel;

@TopComponent.Description(preferredID="SecurityEventsFullScreenTopComponent", iconBase="security_details_large_view.png", persistenceType=1)
public final class SecurityEventsFullScreenTopComponent
extends TopComponent {
    private SecurityEventsFullScreenPanel priority3Panel = new SecurityEventsFullScreenPanel(SecurityEventsFullScreenPanel.PriorityQuery.PRIORITY_3);
    private SecurityEventsFullScreenPanel priority4Panel = new SecurityEventsFullScreenPanel(SecurityEventsFullScreenPanel.PriorityQuery.PRIORITY_4);
    private SecurityEventsFullScreenPanel priority5Panel = new SecurityEventsFullScreenPanel(SecurityEventsFullScreenPanel.PriorityQuery.PRIORITY_5);
    private JXMultiSplitPane msPane;

    public SecurityEventsFullScreenTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SecurityEventsFullScreenTopComponent.class, (String)"CTL_SecurityEventsFullScreenTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SecurityEventsFullScreenTopComponent.class, (String)"HINT_SecurityEventsFullScreenTopComponent"));
        ProxyLookup mainLookup = new ProxyLookup(new Lookup[]{this.priority3Panel.getSelectedEventLookup(), this.priority4Panel.getSelectedEventLookup(), this.priority5Panel.getSelectedEventLookup()});
        this.associateLookup((Lookup)mainLookup);
        MultiSplitLayout.Leaf left = new MultiSplitLayout.Leaf("left");
        MultiSplitLayout.Leaf middle = new MultiSplitLayout.Leaf("middle");
        MultiSplitLayout.Leaf right = new MultiSplitLayout.Leaf("right");
        left.setWeight(0.333);
        middle.setWeight(0.333);
        right.setWeight(0.333);
        List<MultiSplitLayout.Node> children = Arrays.asList(left, new MultiSplitLayout.Divider(), middle, new MultiSplitLayout.Divider(), right);
        MultiSplitLayout.Split modelRoot = new MultiSplitLayout.Split();
        modelRoot.setChildren(children);
        this.msPane.setDividerSize(5);
        this.msPane.setDividerPainter((JXMultiSplitPane.DividerPainter)new MyDividerPainter());
        this.msPane.getMultiSplitLayout().setModel((MultiSplitLayout.Node)modelRoot);
        this.msPane.add((Component)this.priority3Panel, (Object)"left");
        this.msPane.add((Component)this.priority4Panel, (Object)"middle");
        this.msPane.add((Component)this.priority5Panel, (Object)"right");
    }

    private void initComponents() {
        this.msPane = new JXMultiSplitPane();
        this.setPreferredSize(new Dimension(800, 525));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.msPane, -1, 800, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.msPane, -1, 525, Short.MAX_VALUE));
    }

    public void componentOpened() {
        this.priority3Panel.startAutoRefreshTimer();
        this.priority4Panel.startAutoRefreshTimer();
        this.priority5Panel.startAutoRefreshTimer();
        this.priority3Panel.startSearch();
        this.priority4Panel.startSearch();
        this.priority5Panel.startSearch();
    }

    public void componentClosed() {
        this.priority3Panel.stopAutoRefreshTimer();
        this.priority4Panel.stopAutoRefreshTimer();
        this.priority5Panel.stopAutoRefreshTimer();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("priority3PanelQuery", this.priority3Panel.getQuery());
        p.setProperty("priority4PanelQuery", this.priority4Panel.getQuery());
        p.setProperty("priority5PanelQuery", this.priority5Panel.getQuery());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        this.priority3Panel.setQuery(p.getProperty("priority3PanelQuery"));
        this.priority4Panel.setQuery(p.getProperty("priority4PanelQuery"));
        this.priority5Panel.setQuery(p.getProperty("priority5PanelQuery"));
    }

    private class MyDividerPainter
    extends JXMultiSplitPane.DividerPainter {
        private int x = 2;
        private int y = 5;

        private MyDividerPainter() {
        }

        protected void doPaint(Graphics2D g, MultiSplitLayout.Divider divider, int width, int height) {
            g.setColor(new Color(205, 205, 205));
            g.fillRect(0, 0, width, height);
            g.setColor(new Color(175, 175, 175));
            while (this.y < height) {
                g.drawLine(this.x, this.y, this.x, this.y);
                this.x = 2;
                this.y += 5;
            }
            this.x = 2;
            this.y = 5;
        }
    }
}

