/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class BirdViewWindow
extends JWindow
implements MouseMotionListener {
    private Scene scene;
    private BirdViewComponent birdView;
    private boolean shown = false;
    private double zoomFactor = 3.0;
    private Point scenePoint;
    private WidgetAction action = new SceneTrackAction();
    private ViewAncestorListener ancestorListener = new ViewAncestorListener();

    public BirdViewWindow(Scene scene) {
        this.scene = scene;
        this.setSize(new Dimension(256, 256));
        this.setLayout(new BorderLayout());
        this.setAlwaysOnTop(true);
        JPanel pane = new JPanel();
        pane.setBorder(new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(1, 1, 1, 1)));
        pane.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.birdView = new BirdViewComponent();
        this.birdView.setDoubleBuffered(true);
        pane.add((Component)this.birdView, "Center");
    }

    public void invokeShow() {
        if (this.scene.getView() == null) {
            return;
        }
        if (this.shown) {
            return;
        }
        this.shown = true;
        this.birdView.addMouseMotionListener(this);
        this.scene.getPriorActions().addAction(this.action);
        this.scene.getView().addAncestorListener(this.ancestorListener);
        this.updateForViewPoint(null);
    }

    public void invokeHide() {
        if (!this.shown) {
            return;
        }
        this.shown = false;
        this.birdView.removeMouseMotionListener(this);
        this.scene.getPriorActions().removeAction(this.action);
        this.scene.getView().removeAncestorListener(this.ancestorListener);
        this.updateForViewPoint(null);
    }

    public void invokeRepaint() {
        this.birdView.repaint();
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.invokeRepaint();
    }

    public void setWindowSize(Dimension size) {
        Dimension previousSize = this.getSize();
        this.setSize(size);
        if (this.isShowing()) {
            Point location = this.getLocation();
            this.setLocation(location.x + (previousSize.width - size.width) / 2, location.y + (previousSize.height - size.height) / 2);
            this.validate();
        }
    }

    private void updateForViewPoint(Point viewPoint) {
        JComponent view = this.scene.getView();
        if (!this.shown || viewPoint == null || !view.getVisibleRect().contains(viewPoint)) {
            this.scenePoint = null;
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.scenePoint = this.scene.convertViewToScene(viewPoint);
        Point viewOrigin = view.getLocationOnScreen();
        Dimension size = this.getSize();
        this.setBounds(viewOrigin.x + viewPoint.x - size.width / 2, viewOrigin.y + viewPoint.y - size.height / 2, size.width, size.height);
        this.setVisible(true);
        this.birdView.repaint();
    }

    private void updateForBirdViewPoint(Point birdViewPoint) {
        JComponent view = this.scene.getView();
        if (view.isShowing() && this.isShowing()) {
            Point viewOrigin = view.getLocationOnScreen();
            Point birdViewOrigin = this.getLocationOnScreen();
            Dimension size = this.getSize();
            this.updateForViewPoint(new Point(birdViewPoint.x + birdViewOrigin.x - viewOrigin.x, birdViewPoint.y + birdViewOrigin.y - viewOrigin.y));
        } else {
            this.updateForViewPoint(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateForBirdViewPoint(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateForBirdViewPoint(e.getPoint());
    }

    private class BirdViewComponent
    extends JComponent {
        private BirdViewComponent() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D gr = (Graphics2D)g;
            super.paint(g);
            if (BirdViewWindow.this.scenePoint == null) {
                gr.setColor(Color.BLACK);
                gr.fill(this.getBounds());
                return;
            }
            Dimension size = this.getSize();
            AffineTransform previousTransform = gr.getTransform();
            gr.translate(size.width / 2, size.height / 2);
            gr.scale(BirdViewWindow.this.zoomFactor, BirdViewWindow.this.zoomFactor);
            gr.translate(-((BirdViewWindow)BirdViewWindow.this).scenePoint.x, -((BirdViewWindow)BirdViewWindow.this).scenePoint.y);
            BirdViewWindow.this.scene.paint(gr);
            gr.setTransform(previousTransform);
        }
    }

    private class SceneTrackAction
    implements WidgetAction {
        private SceneTrackAction() {
        }

        @Override
        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseEntered(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
            BirdViewWindow.this.updateForViewPoint(widget.getScene().convertSceneToView(widget.convertLocalToScene(event.getPoint())));
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseMoved(Widget widget, WidgetAction.WidgetMouseEvent event) {
            BirdViewWindow.this.updateForViewPoint(widget.getScene().convertSceneToView(widget.convertLocalToScene(event.getPoint())));
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State keyReleased(Widget widget, WidgetAction.WidgetKeyEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State focusGained(Widget widget, WidgetAction.WidgetFocusEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State focusLost(Widget widget, WidgetAction.WidgetFocusEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State dragEnter(Widget widget, WidgetAction.WidgetDropTargetDragEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State dragOver(Widget widget, WidgetAction.WidgetDropTargetDragEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State dropActionChanged(Widget widget, WidgetAction.WidgetDropTargetDragEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetDropTargetEvent event) {
            return WidgetAction.State.CONSUMED;
        }

        @Override
        public WidgetAction.State drop(Widget widget, WidgetAction.WidgetDropTargetDropEvent event) {
            return WidgetAction.State.CONSUMED;
        }
    }

    private class ViewAncestorListener
    implements AncestorListener {
        private ViewAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            BirdViewWindow.this.invokeHide();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

