/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.light.Light;
import com.jme3.light.LightFilter;
import com.jme3.light.LightList;
import com.jme3.light.LightProbeBlendingProcessor;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.util.TempVars;
import java.util.HashSet;

public final class PoiLightProbeLightFilter
implements LightFilter {
    private Camera camera;
    private final HashSet<Light> processedLights = new HashSet();
    private final LightProbeBlendingProcessor processor;

    public PoiLightProbeLightFilter(LightProbeBlendingProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = camera;
        for (Light light : this.processedLights) {
            light.frustumCheckNeeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterLights(Geometry geometry, LightList filteredLightList) {
        TempVars vars = TempVars.get();
        try {
            LightList worldLights = geometry.getWorldLightList();
            for (int i = 0; i < worldLights.size(); ++i) {
                BoundingVolume bv;
                Light light = worldLights.get(i);
                if (light.getType() == Light.Type.Probe) continue;
                if (light.frustumCheckNeeded) {
                    this.processedLights.add(light);
                    light.frustumCheckNeeded = false;
                    light.intersectsFrustum = light.intersectsFrustum(this.camera, vars);
                }
                if (!light.intersectsFrustum || ((bv = geometry.getWorldBound()) instanceof BoundingBox ? !light.intersectsBox((BoundingBox)bv, vars) : bv instanceof BoundingSphere && !Float.isInfinite(((BoundingSphere)bv).getRadius()) && !light.intersectsSphere((BoundingSphere)bv, vars))) continue;
                filteredLightList.add(light);
            }
            this.processor.populateProbe(filteredLightList);
        }
        finally {
            vars.release();
        }
    }
}

