/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import com.jme3.system.lwjgl.LwjglAbstractDisplay;
import com.jme3.system.lwjgl.LwjglDisplay;
import java.awt.Canvas;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class LwjglCanvas
extends LwjglAbstractDisplay
implements JmeCanvasContext {
    protected static final int TASK_NOTHING = 0;
    protected static final int TASK_DESTROY_DISPLAY = 1;
    protected static final int TASK_CREATE_DISPLAY = 2;
    protected static final int TASK_COMPLETE = 3;
    protected static final boolean USE_SHARED_CONTEXT = false;
    private static final Logger logger = Logger.getLogger(LwjglDisplay.class.getName());
    private Canvas canvas;
    private int width;
    private int height;
    private final Object taskLock = new Object();
    private int desiredTask = 0;
    private Thread renderThread;
    private boolean runningFirstTime = true;
    private boolean mouseWasGrabbed = false;
    private boolean mouseWasCreated = false;
    private boolean keyboardWasCreated = false;
    private Pbuffer pbuffer;
    private PixelFormat pbufferFormat;
    private PixelFormat canvasFormat;

    public LwjglCanvas() {
        this.canvas = new GLCanvas();
    }

    @Override
    public JmeContext.Type getType() {
        return JmeContext.Type.Canvas;
    }

    public void create(boolean waitFor) {
        if (this.renderThread == null) {
            logger.log(Level.FINE, "MAIN: Creating OGL thread.");
            this.renderThread = new Thread((Runnable)this, "jME3 Main");
            this.renderThread.start();
        }
        if (waitFor) {
            this.waitFor(true);
        }
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void restart() {
        this.frameRate = this.settings.getFrameRate();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runLoop() {
        if (this.desiredTask != 0) {
            Object object = this.taskLock;
            synchronized (object) {
                switch (this.desiredTask) {
                    case 2: {
                        logger.log(Level.FINE, "OGL: Creating display ..");
                        this.restoreCanvas();
                        this.listener.gainFocus();
                        this.desiredTask = 0;
                        break;
                    }
                    case 1: {
                        logger.log(Level.FINE, "OGL: Destroying display ..");
                        this.listener.loseFocus();
                        this.pauseCanvas();
                    }
                }
                this.desiredTask = 3;
                this.taskLock.notifyAll();
            }
        }
        if (this.renderable.get()) {
            int newWidth = Math.max(this.canvas.getWidth(), 1);
            int newHeight = Math.max(this.canvas.getHeight(), 1);
            if (this.width != newWidth || this.height != newHeight) {
                this.width = newWidth;
                this.height = newHeight;
                if (this.listener != null) {
                    this.listener.reshape(this.width, this.height);
                }
            }
        } else if (this.frameRate <= 0) {
            Display.sync((int)30);
        }
        super.runLoop();
    }

    private void pauseCanvas() {
        if (Mouse.isCreated()) {
            if (Mouse.isGrabbed()) {
                Mouse.setGrabbed((boolean)false);
                this.mouseWasGrabbed = true;
            }
            this.mouseWasCreated = true;
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            this.keyboardWasCreated = true;
            Keyboard.destroy();
        }
        this.renderable.set(false);
        this.destroyContext();
    }

    private void restoreCanvas() {
        logger.log(Level.FINE, "OGL: Waiting for canvas to become displayable..");
        while (!this.canvas.isDisplayable()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, "OGL: Interrupted! ", ex);
            }
        }
        logger.log(Level.FINE, "OGL: Creating display context ..");
        this.renderable.set(true);
        this.createContext(this.settings);
        logger.log(Level.FINE, "OGL: Display is active!");
        try {
            if (this.mouseWasCreated) {
                Mouse.create();
                if (this.mouseWasGrabbed) {
                    Mouse.setGrabbed((boolean)true);
                    this.mouseWasGrabbed = false;
                }
            }
            if (this.keyboardWasCreated) {
                Keyboard.create();
                this.keyboardWasCreated = false;
            }
        }
        catch (LWJGLException ex) {
            logger.log(Level.SEVERE, "Encountered exception when restoring input", ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LwjglCanvas.this.canvas.requestFocus();
            }
        });
    }

    protected PixelFormat acquirePixelFormat(boolean forPbuffer) {
        if (forPbuffer) {
            if (this.pbufferFormat == null) {
                this.pbufferFormat = new PixelFormat(this.settings.getBitsPerPixel(), this.settings.getAlphaBits(), this.settings.getDepthBits(), this.settings.getStencilBits(), 0, 0, 0, 0, this.settings.useStereo3D());
            }
            return this.pbufferFormat;
        }
        if (this.canvasFormat == null) {
            int samples = this.getNumSamplesToUse();
            this.canvasFormat = new PixelFormat(this.settings.getBitsPerPixel(), this.settings.getAlphaBits(), this.settings.getDepthBits(), this.settings.getStencilBits(), samples, 0, 0, 0, this.settings.useStereo3D());
        }
        return this.canvasFormat;
    }

    protected void makePbufferAvailable() throws LWJGLException {
        if (this.pbuffer != null && this.pbuffer.isBufferLost()) {
            logger.log(Level.WARNING, "PBuffer was lost!");
            this.pbuffer.destroy();
            this.pbuffer = null;
        }
        if (this.pbuffer == null) {
            this.pbuffer = new Pbuffer(1, 1, this.acquirePixelFormat(true), null);
            this.pbuffer.makeCurrent();
            logger.log(Level.FINE, "OGL: Pbuffer has been created");
            if (!this.runningFirstTime) {
                this.renderer.resetGLObjects();
            }
        }
        this.pbuffer.makeCurrent();
        if (!this.pbuffer.isCurrent()) {
            throw new LWJGLException("Pbuffer cannot be made current");
        }
    }

    protected void destroyPbuffer() {
        if (this.pbuffer != null) {
            if (!this.pbuffer.isBufferLost()) {
                this.pbuffer.destroy();
            }
            this.pbuffer = null;
        }
    }

    @Override
    protected void destroyContext() {
        try {
            this.renderer.cleanup();
            if (Display.isCreated()) {
                if (Keyboard.isCreated()) {
                    Keyboard.destroy();
                }
                if (JmeSystem.getPlatform() == Platform.Windows32 || JmeSystem.getPlatform() == Platform.Windows64) {
                    // empty if block
                }
                Display.destroy();
            }
            if (!this.needClose.get()) {
                this.makePbufferAvailable();
                this.renderer.invalidateState();
            } else {
                this.destroyPbuffer();
            }
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed make pbuffer available", (Throwable)ex);
        }
    }

    @Override
    protected void createContext(AppSettings settings) {
        this.frameRate = settings.getFrameRate();
        this.allowSwapBuffers = settings.isSwapBuffers();
        try {
            if (this.renderable.get()) {
                if (!this.runningFirstTime) {
                    this.renderer.cleanup();
                }
                this.destroyPbuffer();
                if (Keyboard.isCreated()) {
                    Keyboard.destroy();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Display.setVSyncEnabled((boolean)settings.isVSync());
                Display.setParent((Canvas)this.canvas);
                Display.create((PixelFormat)this.acquirePixelFormat(false));
                this.renderer.invalidateState();
            } else {
                this.makePbufferAvailable();
            }
            if (this.runningFirstTime) {
                this.initContextFirstTime();
                this.runningFirstTime = false;
            }
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed to initialize OpenGL context", (Throwable)ex);
        }
    }

    private class GLCanvas
    extends Canvas {
        private GLCanvas() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotify() {
            super.addNotify();
            if (LwjglCanvas.this.renderThread != null && LwjglCanvas.this.renderThread.getState() == Thread.State.TERMINATED) {
                return;
            }
            if (LwjglCanvas.this.renderThread == null) {
                logger.log(Level.FINE, "EDT: Creating OGL thread.");
                LwjglCanvas.this.canvas.setFocusable(true);
                LwjglCanvas.this.canvas.setIgnoreRepaint(true);
                LwjglCanvas.this.renderThread = new Thread((Runnable)LwjglCanvas.this, "jME3 Main");
                LwjglCanvas.this.renderThread.start();
            } else if (LwjglCanvas.this.needClose.get()) {
                return;
            }
            logger.log(Level.FINE, "EDT: Telling OGL to create display ..");
            Object object = LwjglCanvas.this.taskLock;
            synchronized (object) {
                LwjglCanvas.this.desiredTask = 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotify() {
            if (LwjglCanvas.this.needClose.get()) {
                logger.log(Level.FINE, "EDT: Application is stopped. Not restoring canvas.");
                super.removeNotify();
                return;
            }
            logger.log(Level.FINE, "EDT: Telling OGL to destroy display ..");
            Object object = LwjglCanvas.this.taskLock;
            synchronized (object) {
                LwjglCanvas.this.desiredTask = 1;
                while (LwjglCanvas.this.desiredTask != 3) {
                    try {
                        LwjglCanvas.this.taskLock.wait();
                    }
                    catch (InterruptedException ex) {
                        super.removeNotify();
                        return;
                    }
                }
                LwjglCanvas.this.desiredTask = 0;
            }
            logger.log(Level.FINE, "EDT: Acknowledged receipt of canvas death");
            super.removeNotify();
        }
    }
}

