/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart;

import java.awt.Paint;
import java.awt.event.MouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import rs.co.ast.chart.ASTChart;
import rs.co.ast.chart.ByPriorityChartTooltipGenerator;

public class ByPriorityChart
extends ASTChart {
    private TimeTableXYDataset timeTableDataset;
    private StackedXYBarRenderer barRenderer;

    public ByPriorityChart(TimeTableXYDataset dataset) {
        this.timeTableDataset = dataset;
        this.barRenderer = new StackedXYBarRenderer(0.0);
        this.barRenderer.setAutoPopulateSeriesPaint(false);
        this.barRenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.barRenderer.setDrawBarOutline(true);
        this.barRenderer.setShadowVisible(false);
        this.barRenderer.setBaseToolTipGenerator((XYToolTipGenerator)ByPriorityChartTooltipGenerator.getTimeSeriesInstance());
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            int colorIndex = i;
            String[] split = seriesKey.split(" ");
            if (split.length == 2) {
                colorIndex = Integer.valueOf(split[1]) - 1;
            }
            this.barRenderer.setSeriesPaint(i, (Paint)COLORS[colorIndex]);
        }
        DateAxis dateAxis = new DateAxis();
        dateAxis.setLowerMargin(0.02);
        dateAxis.setUpperMargin(0.02);
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAutoRangeIncludesZero(true);
        this.plot = new XYPlot((XYDataset)dataset, (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)this.barRenderer);
        this.plot.addChangeListener((PlotChangeListener)this);
        this.plot.getDomainAxis().setLowerMargin(0.0);
        this.plot.getDomainAxis().setUpperMargin(0.0);
        this.chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        new StandardChartTheme("JFree").apply(this.chart);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.addMouseListener((MouseListener)this);
    }

    public void updateChart(TimeTableXYDataset dataset) {
        Object seriesKey;
        this.chartPanel.restoreAutoBounds();
        this.timeTableDataset.clear();
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            seriesKey = dataset.getSeriesKey(s);
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double val = dataset.getYValue(s, i);
                TimePeriod timePeriod = dataset.getTimePeriod(i);
                this.timeTableDataset.add(timePeriod, (Number)val, (Comparable)seriesKey, true);
            }
        }
        for (int i = 0; i < this.timeTableDataset.getSeriesCount(); ++i) {
            seriesKey = (String)((Object)dataset.getSeriesKey(i));
            int colorIndex = i;
            String[] split = ((String)seriesKey).split(" ");
            if (split.length == 2) {
                colorIndex = Integer.valueOf(split[1]) - 1;
            }
            this.barRenderer.setSeriesPaint(i, (Paint)COLORS[colorIndex]);
        }
        this.chartPanel.repaint();
    }
}

