/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.type.RunDirectionEnum;

public class PdfTextRenderer
extends AbstractPdfTextRenderer {
    public PdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        this(jasperReportsContext, ignoreMissingFont, true, false);
    }

    public PdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    @Override
    public void draw() {
        AbstractTextRenderer.TabSegment segment = (AbstractTextRenderer.TabSegment)this.segments.get(this.segmentIndex);
        float advance = segment.layout.getVisibleAdvance();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.pdfExporter.getPhrase(segment.as, segment.text, this.text), (float)this.x + this.drawPosX + this.leftOffsetFactor * advance, (float)(this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset + this.lineHeight - this.drawPosY, (float)this.x + this.drawPosX + advance + this.rightOffsetFactor * advance, (float)(this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - 400.0f - this.drawPosY, 0.0f, this.horizontalAlignment == 3 && (!segment.isLastLine || this.isLastParagraph && this.justifyLastLine) ? 8 : this.horizontalAlignment);
        colText.setLeading(this.lineHeight);
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

