/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.graph;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import rs.co.ast.aspen.core.module.visengine.graph.Attributed;

public class Id {
    private static final MessageDigest SHA256;
    private final StringBuilder sb = new StringBuilder();

    public Id(Map<String, String> attrs, String ... names) {
        for (String name : names) {
            this.sb.append(name).append(".");
        }
        if (attrs != null) {
            List<String> sorted = this.sortByKey(attrs.keySet());
            for (String skey : sorted) {
                String key = Attributed.key(skey);
                this.sb.append(key).append("=").append(attrs.get(skey)).append("\n");
            }
        }
    }

    public String toString() {
        return Base64.encodeBase64URLSafeString((byte[])SHA256.digest(this.sb.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private List<String> sortByKey(Set<String> keySet) {
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(keySet);
        Collections.sort(r);
        return r;
    }

    static {
        try {
            SHA256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

