/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.file;

import com.jme3.scene.plugins.fbx.file.FbxElement;

public abstract class FbxId {
    public static final FbxId ROOT = new LongFbxId(0L);

    protected FbxId() {
    }

    public abstract boolean isNull();

    public static FbxId create(Object obj) {
        if (obj instanceof Long) {
            return new LongFbxId((Long)obj);
        }
        if (obj instanceof String) {
            return new StringFbxId((String)obj);
        }
        throw new UnsupportedOperationException("Unsupported ID object type: " + obj.getClass());
    }

    public static FbxId getObjectId(FbxElement el) {
        if (el.propertiesTypes.length == 2 && el.propertiesTypes[0] == 'S' && el.propertiesTypes[1] == 'S') {
            return new StringFbxId((String)el.properties.get(0));
        }
        if (el.propertiesTypes.length == 3 && el.propertiesTypes[0] == 'L' && el.propertiesTypes[1] == 'S' && el.propertiesTypes[2] == 'S') {
            return new LongFbxId((Long)el.properties.get(0));
        }
        return null;
    }

    private static final class LongFbxId
    extends FbxId {
        private final long id;

        public LongFbxId(long id) {
            this.id = id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != LongFbxId.class) {
                return false;
            }
            return this.id == ((LongFbxId)obj).id;
        }

        @Override
        public boolean isNull() {
            return this.id == 0L;
        }

        public String toString() {
            return Long.toString(this.id);
        }
    }

    private static final class StringFbxId
    extends FbxId {
        private final String id;

        public StringFbxId(String id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != StringFbxId.class) {
                return false;
            }
            return this.id.equals(((StringFbxId)obj).id);
        }

        public String toString() {
            return this.id;
        }

        @Override
        public boolean isNull() {
            return this.id.equals("Scene\u0000\u0001Model");
        }
    }
}

