/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.util.BufferAllocator;
import com.jme3.util.BufferUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionAllocator
implements BufferAllocator {
    private static Method cleanerMethod = null;
    private static Method cleanMethod = null;
    private static Method viewedBufferMethod = null;
    private static Method freeMethod = null;

    private static Method loadMethod(String className, String methodName) {
        try {
            Method method = Class.forName(className).getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Throwable t) {
            if (t.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                return null;
            }
            throw t;
        }
    }

    @Override
    public void destroyDirectBuffer(Buffer toBeDestroyed) {
        try {
            if (freeMethod != null) {
                freeMethod.invoke((Object)toBeDestroyed, new Object[0]);
            } else {
                Method localCleanerMethod = cleanerMethod == null ? ReflectionAllocator.loadMethod(toBeDestroyed.getClass().getName(), "cleaner") : cleanerMethod;
                if (localCleanerMethod == null) {
                    Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", toBeDestroyed);
                } else {
                    Object cleaner = localCleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
                    if (cleaner != null) {
                        Method localCleanMethod = cleanMethod == null ? (cleaner instanceof Runnable ? ReflectionAllocator.loadMethod(Runnable.class.getName(), "run") : ReflectionAllocator.loadMethod(cleaner.getClass().getName(), "clean")) : cleanMethod;
                        if (localCleanMethod == null) {
                            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", toBeDestroyed);
                        } else {
                            localCleanMethod.invoke(cleaner, new Object[0]);
                        }
                    } else {
                        Method localViewedBufferMethod = viewedBufferMethod == null ? ReflectionAllocator.loadMethod(toBeDestroyed.getClass().getName(), "viewedBuffer") : viewedBufferMethod;
                        if (localViewedBufferMethod == null) {
                            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", toBeDestroyed);
                        } else {
                            Object viewedBuffer = localViewedBufferMethod.invoke((Object)toBeDestroyed, new Object[0]);
                            if (viewedBuffer != null) {
                                if (viewedBuffer instanceof Buffer) {
                                    this.destroyDirectBuffer((Buffer)viewedBuffer);
                                }
                            } else {
                                Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", toBeDestroyed);
                            }
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
    }

    @Override
    public ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    static {
        cleanerMethod = ReflectionAllocator.loadMethod("sun.nio.ch.DirectBuffer", "cleaner");
        cleanMethod = ReflectionAllocator.loadMethod("sun.misc.Cleaner", "clean");
        viewedBufferMethod = ReflectionAllocator.loadMethod("sun.nio.ch.DirectBuffer", "viewedBuffer");
        if (viewedBufferMethod == null) {
            viewedBufferMethod = ReflectionAllocator.loadMethod("sun.nio.ch.DirectBuffer", "attachment");
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        Class<?> clazz = bb.getClass();
        try {
            freeMethod = clazz.getMethod("free", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

