/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ParsingDebugInfo;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTable;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTableModel;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTableRenderer;
import rs.co.ast.aspen.gui.rawlogs.RawLogSearchQueryUpdate;
import rs.co.ast.aspen.gui.rawlogs.RawLogsTopComponent;
import rs.co.ast.aspen.gui.rawlogs.ResendEventDialog;
import rs.co.ast.aspen.gui.rawlogs.SimulatorResultsPanel;
import rs.co.ast.aspen.gui.rawlogs.query.QueryManager;

@TopComponent.Description(preferredID="RawLogDetailsTopComponent", iconBase="application_form_magnify.png", persistenceType=0)
public final class RawLogDetailsTopComponent
extends TopComponent {
    private RawLogDetailsTableModel tableModel = new RawLogDetailsTableModel();
    private static final Logger logger = Logger.getLogger(RawLogDetailsTopComponent.class.getName());
    private Lookup.Result<RawLogSimWrapper> lr = Utilities.actionsGlobalContext().lookupResult(RawLogSimWrapper.class);
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup searchQueryUpdate = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private RawLogSimWrapper rlsw;
    private RawLogSearchQueryUpdate prevSearchQueryUpdate = null;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem miCopy = new JMenuItem(NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"RawLogDetailsTopComponent.miCopy.text"));
    private JButton bCopyRawLogText;
    private JButton bResentEvent;
    private JButton bSimulateParsing;
    private JScrollPane jScrollPane1;
    private JTable tMetaData;

    public RawLogDetailsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"CTL_RawLogDetailsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"HINT_RawLogDetailsTopComponent"));
        this.associateLookup(this.searchQueryUpdate);
        ActionListener copyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RawLogDetailsTableModel.Item entry = (RawLogDetailsTableModel.Item)RawLogDetailsTopComponent.this.tMetaData.getValueAt(RawLogDetailsTopComponent.this.tMetaData.getSelectedRow(), 0);
                if (entry.getKey() != null && entry.getValue() != null) {
                    String query = QueryManager.copyRLDetailsRow(entry, RawLogDetailsTopComponent.this.tMetaData.getSelectedColumn());
                    StringSelection selection = new StringSelection(query);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tMetaData.registerKeyboardAction(copyListener, "Copy", stroke, 0);
        this.tMetaData.setDefaultRenderer(RawLogDetailsTableModel.Item.class, new RawLogDetailsTableRenderer());
        this.tMetaData.setSelectionMode(0);
        this.tMetaData.setCellSelectionEnabled(true);
        this.tMetaData.setComponentPopupMenu(this.popupMenu);
        this.tMetaData.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RawLogDetailsTableModel.Item item;
                if ((e.isControlDown() || e.isShiftDown() || e.isAltDown()) && (item = (RawLogDetailsTableModel.Item)RawLogDetailsTopComponent.this.tMetaData.getValueAt(RawLogDetailsTopComponent.this.tMetaData.getSelectedRow(), 0)) != null && RawLogDetailsTopComponent.this.rlsw != null && item.getKey() != null && item.getValue() != null) {
                    String query = QueryManager.makeRLDetailsQuery(item, RawLogDetailsTopComponent.this.rlsw, e, RawLogDetailsTopComponent.this.tMetaData.getSelectedColumn());
                    RawLogSearchQueryUpdate squ = new RawLogSearchQueryUpdate(query, false, RawLogDetailsTopComponent.this.rlsw.getTag());
                    if (RawLogDetailsTopComponent.this.prevSearchQueryUpdate != null) {
                        RawLogDetailsTopComponent.this.instanceContent.remove((Object)RawLogDetailsTopComponent.this.prevSearchQueryUpdate);
                    }
                    RawLogDetailsTopComponent.this.instanceContent.add((Object)squ);
                    RawLogDetailsTopComponent.this.prevSearchQueryUpdate = squ;
                    RawLogDetailsTopComponent.this.rlsw.setQuery(query);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int row = source.rowAtPoint(e.getPoint());
                int column = source.columnAtPoint(e.getPoint());
                if (!source.isRowSelected(row)) {
                    source.changeSelection(row, column, false, false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lr.allInstances();
        this.lr.allItems();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof RawLogSimWrapper)) continue;
                    RawLogDetailsTopComponent.this.setRawLogSimWrapper((RawLogSimWrapper)o);
                }
            }
        });
        this.miCopy.addActionListener(copyListener);
        this.popupMenu.add(this.miCopy);
    }

    public synchronized void setRawLogSimWrapper(final RawLogSimWrapper rlsw) {
        this.rlsw = rlsw;
        if (rlsw != null && rlsw.getRawLog() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RawLogDetailsTopComponent.this.tableModel.setLog(rlsw);
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tMetaData = new RawLogDetailsTable(this.tableModel);
        this.bCopyRawLogText = new JButton();
        this.bResentEvent = new JButton();
        this.bSimulateParsing = new JButton();
        this.jScrollPane1.setViewportView(this.tMetaData);
        Mnemonics.setLocalizedText((AbstractButton)this.bCopyRawLogText, (String)NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"RawLogDetailsTopComponent.bCopyRawLogText.text"));
        this.bCopyRawLogText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogDetailsTopComponent.this.bCopyRawLogTextActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bResentEvent, (String)NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"RawLogDetailsTopComponent.bResentEvent.text"));
        this.bResentEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogDetailsTopComponent.this.bResentEventActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSimulateParsing, (String)NbBundle.getMessage(RawLogDetailsTopComponent.class, (String)"RawLogDetailsTopComponent.bSimulateParsing.text"));
        this.bSimulateParsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RawLogDetailsTopComponent.this.bSimulateParsingActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bCopyRawLogText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bSimulateParsing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addComponent(this.bResentEvent))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 431, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bCopyRawLogText).addComponent(this.bResentEvent).addComponent(this.bSimulateParsing)).addContainerGap()));
    }

    private void bCopyRawLogTextActionPerformed(ActionEvent evt) {
        if (this.rlsw != null && this.rlsw.getRawLog() != null) {
            StringSelection selection = new StringSelection(this.rlsw.getRawLog().getText());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
    }

    private void bResentEventActionPerformed(ActionEvent evt) {
        if (this.rlsw != null && this.rlsw.getRawLog() != null && !this.rlsw.getRawLog().getId().toLowerCase().equals("no data!")) {
            ResendEventDialog dialog = new ResendEventDialog(this.rlsw.getRawLog());
            dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
            dialog.setVisible(true);
            dialog.setDefaultCloseOperation(2);
        }
    }

    private void bSimulateParsingActionPerformed(ActionEvent evt) {
        if (this.rlsw != null && this.rlsw.getRawLog() != null) {
            RequestProcessor.getDefault().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RawLogsTopComponent.class, (String)"simulate-parsing.message"));
                    ph.start();
                    ph.switchToIndeterminate();
                    try {
                        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
                        ParsingDebugInfo simulateParsing = apiService.simulateParsing(RawLogDetailsTopComponent.this.rlsw.getRawLog().getId(), RawLogDetailsTopComponent.this.rlsw.getTimeStart(), RawLogDetailsTopComponent.this.rlsw.getTimeFinish());
                        SimulatorResultsPanel srp = new SimulatorResultsPanel(RawLogDetailsTopComponent.this.rlsw.getRawLog().getText(), simulateParsing.getSteps());
                        DialogDescriptor dd = new DialogDescriptor((Object)srp, NbBundle.getMessage(RawLogsTopComponent.class, (String)"SimulationResults.title"), false, null);
                        Dialog createDialog = DialogDisplayer.getDefault().createDialog(dd);
                        createDialog.setVisible(true);
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        ph.finish();
                    }
                }
            });
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("tmd_col_count", String.valueOf(this.tMetaData.getColumnModel().getColumnCount()));
        for (int i = 0; i < this.tMetaData.getColumnModel().getColumnCount(); ++i) {
            TableColumn tc = this.tMetaData.getColumnModel().getColumn(i);
            p.setProperty(String.format("tmd_col%d_width", i), String.valueOf(tc.getWidth()));
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String colCountString = p.getProperty("tmd_col_count");
        try {
            int colCount = colCountString != null ? Integer.valueOf(colCountString) : 0;
            for (int i = 0; i < colCount; ++i) {
                String s = p.getProperty("tmd_col" + i + "_width");
                if (s == null) continue;
                this.tMetaData.getColumnModel().getColumn(i).setPreferredWidth(Integer.valueOf(s));
            }
        }
        catch (NumberFormatException ex) {
            logger.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
    }
}

