/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.math.FastMath;
import java.util.Collection;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;

public class EdgesLayout {
    public static void layout(Renderer.SpatialMode mode, Collection<Edge> edges) {
        switch (mode) {
            case _2D: {
                EdgesLayout.layout2d(edges);
                break;
            }
            case _3D: {
                EdgesLayout.layout3d(edges);
            }
        }
    }

    private static void layout2d(Collection<Edge> edges) {
        float sum = EdgesLayout.sumRadii(edges);
        float l = -sum;
        for (Edge edge : edges) {
            float n = EdgesLayout.radius(edge);
            edge.set("%offset_x", "0");
            edge.set("%offset_y", String.valueOf(l += n));
            l += n;
        }
    }

    private static void layout3d(Collection<Edge> edges) {
        float sum = EdgesLayout.sumRadii(edges);
        float alpha = (float)(Math.PI * 2 / (double)sum);
        float R = (float)((double)sum / Math.PI);
        R *= 1.1f - 0.03f * (float)edges.size();
        float angle = 0.0f;
        for (Edge edge : edges) {
            float n = EdgesLayout.radius(edge);
            float x = R * FastMath.cos((float)(angle += alpha * n / 2.0f));
            float y = R * FastMath.sin((float)angle);
            edge.set("%offset_x", String.valueOf(x));
            edge.set("%offset_y", String.valueOf(y));
            angle += alpha * n / 2.0f;
        }
    }

    private static float radius(Edge edge) {
        return Float.valueOf(edge.get("%radius", "1")).floatValue();
    }

    private static float sumRadii(Collection<Edge> edges) {
        float sum = 0.0f;
        for (Edge edge : edges) {
            sum += EdgesLayout.radius(edge);
        }
        return sum;
    }
}

