/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.VisualizationEngine;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationManager;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationPropertiesTopComponent;

public abstract class Producer
extends Thread {
    protected static final String DEFAULT_SEARCH = "*";
    protected static final Logger LOGGER = Logger.getLogger(Producer.class.getName());
    protected List<SecurityEvent> activeList = null;
    protected ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    protected long count = 0L;
    protected int eventsPerStep = 1;
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected long from;
    protected Future<List<SecurityEvent>> future = null;
    protected Integer goToNextStep = -1;
    protected volatile boolean idle = false;
    protected int indexFrom = 0;
    protected int indexTo = 0;
    protected DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    protected Mode mode;
    protected int page = 1000;
    protected ProgressHandle ph;
    protected String progressHandleName = NbBundle.getMessage(VisualizationTopComponent.class, (String)"SecurityEvents.progress.title");
    protected String query;
    protected final BlockingQueue<List<Node>> queue;
    protected SearchState searchState = new SearchState();
    protected long stepDelay = 100L;
    protected List<SecurityEvent> tempList = null;
    protected long to;
    protected VisualizationManager visManager = (VisualizationManager)Lookup.getDefault().lookup(VisualizationManager.class);
    protected VisualizationPropertiesTopComponent visPropTC = (VisualizationPropertiesTopComponent)WindowManager.getDefault().findTopComponent("VisualizationPropertiesTopComponent");

    public Producer(String name, BlockingQueue<List<Node>> queue) {
        super(name);
        this.queue = queue;
        this.mode = Mode.NORMAL;
    }

    @Override
    public abstract void run();

    protected void changeMode(Mode mode) {
        this.mode = mode;
        this.sleep();
        LOGGER.info(String.format("Mode has been changed to %s and is sleeping", new Object[]{mode}));
    }

    protected Mode getMode() {
        return this.mode;
    }

    protected synchronized void nextStep() {
        this.goToNextStep = 1;
    }

    protected void sleep() {
        this.idle = true;
        this.goToNextStep = 1;
        this.visPropTC.updateStatusLabel(NbBundle.getMessage(VisualizationTopComponent.class, (String)"Producer.status.paused.title"));
        LOGGER.info("Producer sleeping.");
    }

    protected void updateStatusSleepSearching() {
        this.visPropTC.updateStatusLabel(NbBundle.getMessage(VisualizationTopComponent.class, (String)"Producer.status.searching.title"));
    }

    protected void updateStatusRunning() throws MissingResourceException {
        this.visPropTC.updateStatusLabel(NbBundle.getMessage(VisualizationTopComponent.class, (String)"Producer.status.running.title"));
    }

    protected synchronized void updateEventsPerStep(int eps) {
        this.eventsPerStep = eps;
        LOGGER.info(String.format("Updated events per step to %d", eps));
    }

    protected synchronized void updateStartDate(long startDate) {
        this.from = startDate;
        LOGGER.info(String.format("Updated start date to %d", startDate));
    }

    protected void updateStepDelay(long stepDelay) {
        this.stepDelay = stepDelay;
        LOGGER.info(String.format("Updated step delay to %d", stepDelay));
    }

    protected void wake() {
        this.idle = false;
        this.goToNextStep = -1;
        this.updateStatusRunning();
        LOGGER.info("Producer awake.");
    }

    protected Future<List<SecurityEvent>> executeSearch(String query, long from, long to) {
        return this.executorService.submit(() -> this.search(query, from, to));
    }

    protected final void generateQuery() {
        String q = this.visManager.getConfig() == null ? DEFAULT_SEARCH : this.visManager.getConfig().getVisConfig().QUERY;
        this.query = q == null || q.isEmpty() ? DEFAULT_SEARCH : q;
        String queryAddition = this.visManager.getSettings().getQueryAddition();
        if (queryAddition != null && !queryAddition.isEmpty()) {
            this.query = "(" + this.query + ") AND (" + queryAddition + ")";
        }
        this.visPropTC.updateDataQuery(this.query);
    }

    protected abstract List<SecurityEvent> search(String var1, long var2, long var4) throws ApiServiceException_Exception;

    protected final void updateFinishDate(long finishDate) {
        this.to = finishDate;
        LOGGER.info(String.format("Updated finish date to %d", finishDate));
    }

    protected void stopThread() {
        this.interrupt();
    }

    protected final void sleepThread(long duration) {
        try {
            Producer.sleep(duration);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, String.format("Producer '%s' thread interrupted", this.getName()), ex);
            this.stopThread();
        }
    }

    protected List<Node> allNodesList() throws InterruptedException, ExecutionException {
        Future f = this.visManager.getApp().enqueue(() -> ((VisualizationEngine)this.visManager.getConfig().getVisEngine()).allNodesList());
        return (List)f.get();
    }

    public static enum Mode {
        NORMAL,
        STEPPING,
        ERROR;

    }
}

