/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.export.strategies;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogsSearchResults;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.gui.rawlogs.export.strategies.ExportStrategy;

public class TXTExportStrategy
extends ExportStrategy {
    private static final Charset CHAR_ENCODING = StandardCharsets.UTF_8;

    public TXTExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        super(query, exportPath, startTime, finishTime, indexSplit, "txt");
    }

    @Override
    public SwingWorker<byte[], Void> search(final String fileName, final SearchState searchState, final DateRange dateRange) {
        return new SwingWorker<byte[], Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected byte[] doInBackground() throws Exception {
                RawLogsSearchResults result = TXTExportStrategy.this.fetch(searchState, dateRange);
                ExportStrategy.logger.info(String.format("FETCH - s: %s - f: %s, o: %d, d: %d, t: %d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getOffset(), result.getContainer().getRowLogs().size(), result.getSearchState().getTotalHits()));
                if (!result.getContainer().getErrors().isEmpty()) {
                    ExportStrategy.logger.warning(String.format("FETCH ERRORS - %s", result.getContainer().getErrors()));
                    TXTExportStrategy.this.fileSkippedSupport.fireFileSkippedEvent(fileName, dateRange, searchState);
                    return null;
                }
                try (ByteArrayOutputStream osFile = new ByteArrayOutputStream();){
                    int progress = 0;
                    for (RawLog r : result.getContainer().getRowLogs()) {
                        try (ByteArrayOutputStream osRawLog = new ByteArrayOutputStream();){
                            StringBuilder sb = new StringBuilder();
                            String facility = "";
                            String severity = "";
                            for (RawLog.MetaData.Entry entry : r.getMetaData().getEntry()) {
                                if (entry.getKey().equalsIgnoreCase("facility")) {
                                    facility = entry.getValue();
                                    continue;
                                }
                                if (!entry.getKey().equalsIgnoreCase("severity")) continue;
                                severity = entry.getValue();
                            }
                            sb.append(new DateTime((Object)r.getTimestamp()).toString("yyyy-MM-dd HH:mm:ss"));
                            sb.append(" ");
                            sb.append(facility);
                            sb.append(".");
                            sb.append(severity);
                            sb.append(" ");
                            sb.append(r.getText().replaceAll(System.lineSeparator(), ""));
                            byte[] val = sb.toString().getBytes(CHAR_ENCODING);
                            osRawLog.write(val);
                            osRawLog.write(System.lineSeparator().getBytes(CHAR_ENCODING));
                            osRawLog.writeTo(osFile);
                        }
                        TXTExportStrategy.this.progressValueChangedSupport.fireProgressValueChangedEvent(progress++, progress, result.getContainer().getRowLogs().size(), 0.0f);
                    }
                    Object object = osFile.toByteArray();
                    return object;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    byte[] file = (byte[])this.get();
                    if (file == null) {
                        return;
                    }
                    TXTExportStrategy.this.taskMonitor.completeFetch(fileName);
                    TXTExportStrategy.this.fileCreatedSupport.fireFileCreatedEvent(fileName, file, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }
}

