/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.prsmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ParsingRuleAssignment;
import rs.co.ast.aspen.api.service.ParsingRuleDTO;
import rs.co.ast.aspen.api.service.ParsingRuleMetaRule;
import rs.co.ast.aspen.api.service.ParsingRuleSetDTO;
import rs.co.ast.aspen.api.service.ParsingRuleTestCase;
import rs.co.ast.aspen.api.service.ParsingRuleTestCaseCheck;
import rs.co.ast.aspen.api.service.ParsingRuleTestCaseCheckType;
import rs.co.ast.aspen.api.service.ParsingRulesGroupDTO;
import rs.co.ast.aspen.api.service.ParsingUpdateObjectDTO;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RegressionTestResult;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.core.module.prsmodel.DeepObjectCopy;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;

public class RuleSetModel {
    public static final String PROP_EDITMODE_CHANGED = "editModeChanged";
    public static final String PROP_GROUP_ADDED = "groupAdded";
    public static final String PROP_GROUP_CHANGED = "groupChanged";
    public static final String PROP_GROUP_REMOVED = "groupRemoved";
    public static final String PROP_RULESET_ADD = "ruleSetAdded";
    public static final String PROP_RULESET_CHANGED = "ruleSetChanged";
    public static final String PROP_RULESET_REMOVED = "ruleSetRemoved";
    public static final String PROP_RULE_ADDED = "ruleAdded";
    public static final String PROP_RULE_CHANGED = "ruleChanged";
    public static final String PROP_RULE_REMOVED = "ruleRemoved";
    private static final Logger LOGGER = Logger.getLogger(RuleSetModel.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private Map<String, ParsingRulesGroupDTOWrapper> copygroups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
    private Map<String, List<ParsingRulesGroupDTOWrapper>> copygroupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
    private Map<String, ParsingRuleDTOWrapper> copyrules = new HashMap<String, ParsingRuleDTOWrapper>();
    private Map<String, List<ParsingRuleDTOWrapper>> copyrulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
    private Map<String, ParsingRuleSetDTOWrapper> copyrulesets = new HashMap<String, ParsingRuleSetDTOWrapper>();
    private boolean editMode = false;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Map<String, ParsingRulesGroupDTOWrapper> groups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
    private Map<String, List<ParsingRulesGroupDTOWrapper>> groupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private RulesCallable rc;
    private RulesGroupCallable rgc;
    private RuleSetCallable rsc;
    private Map<String, ParsingRuleDTOWrapper> rules = new HashMap<String, ParsingRuleDTOWrapper>();
    private Map<String, List<ParsingRuleDTOWrapper>> rulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
    private Map<String, ParsingRuleSetDTOWrapper> rulesets = new HashMap<String, ParsingRuleSetDTOWrapper>();
    private Future<List<ParsingRulesGroupDTO>> submitGroups;
    private Future<List<ParsingRuleSetDTO>> submitRuleSets;
    private Future<List<ParsingRuleDTO>> submitRules;

    public void addAssignment(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            ParsingRuleAssignment assignment = new ParsingRuleAssignment();
            assignment.setId(UUID.randomUUID().toString());
            assignment.setCategory(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.category.text"));
            assignment.setKey(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.key.text"));
            assignment.setValue(NbBundle.getMessage(RuleSetModel.class, (String)"Assignment.value.text"));
            rule.addAssignment(assignment);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public String addEmptyGroup(String parentId) {
        return this.addGroup(parentId, NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"), "");
    }

    public String addGroup(String parentId, String name, String description) {
        ParsingRulesGroupDTOWrapper parentGroup;
        ParsingRulesGroupDTO group = new ParsingRulesGroupDTO();
        ParsingRulesGroupDTOWrapper wgroup = new ParsingRulesGroupDTOWrapper(group);
        group.setId(this.generateId());
        group.setName(name);
        group.setDescription(description);
        if (parentId != null) {
            group.setParentId(parentId);
        } else {
            LOGGER.info(String.format("Group: %s [%s], ParentId: null", group.getName(), group.getId()));
        }
        this.markGroupAsDirty(wgroup);
        this.groups.put(group.getId(), wgroup);
        List<ParsingRulesGroupDTOWrapper> get = this.groupsForParent.get(parentId);
        if (get == null) {
            get = new ArrayList<ParsingRulesGroupDTOWrapper>();
        }
        get.add(wgroup);
        if (!get.isEmpty()) {
            this.groupsForParent.put(parentId, get);
        }
        if ((parentGroup = this.groups.get(parentId)) != null) {
            if (!parentGroup.getGroupIds().contains(group.getId())) {
                parentGroup.getGroupIds().add(group.getId());
            }
        } else {
            ParsingRuleSetDTOWrapper parentRuleSet = this.rulesets.get(parentId);
            if (!parentRuleSet.getGroupIds().contains(group.getId())) {
                parentRuleSet.getGroupIds().add(group.getId());
            }
        }
        this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, wgroup);
        return group.getId();
    }

    public void addGroup(ParsingRulesGroupDTOWrapper group) {
        ParsingRulesGroupDTOWrapper parentGroup;
        this.markGroupAsDirty(group);
        this.groups.put(group.getId(), group);
        List<ParsingRulesGroupDTOWrapper> get = this.groupsForParent.get(group.getParentId());
        if (get == null) {
            get = new ArrayList<ParsingRulesGroupDTOWrapper>();
        }
        get.add(group);
        if (!get.isEmpty()) {
            this.groupsForParent.put(group.getParentId(), get);
        }
        if ((parentGroup = this.groups.get(group.getParentId())) != null) {
            if (!parentGroup.getGroupIds().contains(group.getId())) {
                parentGroup.getGroupIds().add(group.getId());
            }
        } else {
            ParsingRuleSetDTOWrapper parentRuleSet = this.rulesets.get(group.getParentId());
            if (!parentRuleSet.getGroupIds().contains(group.getId())) {
                parentRuleSet.getGroupIds().add(group.getId());
            }
        }
        this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, group);
    }

    public void addGroups(List<ParsingRulesGroupDTOWrapper> groups) {
        for (ParsingRulesGroupDTOWrapper group : groups) {
            this.addGroup(group);
        }
    }

    public void addMetaRule(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            ParsingRuleMetaRule metaRule = new ParsingRuleMetaRule();
            metaRule.setId(UUID.randomUUID().toString());
            metaRule.setActive(Boolean.valueOf(false));
            metaRule.setRuleEL(NbBundle.getMessage(RuleSetModel.class, (String)"MetaRuleExpression.text"));
            rule.addMetaRule(metaRule);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addRule(String groupId) {
        this.addRule(groupId, null);
    }

    public void addRule(String groupId, String regexp) {
        if (this.rules != null) {
            ParsingRuleDTO rule = new ParsingRuleDTO();
            rule.setId(UUID.randomUUID().toString());
            rule.setDescription(NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"));
            if (regexp != null) {
                rule.setRegexp(regexp);
            }
            ParsingRuleDTOWrapper wrule = new ParsingRuleDTOWrapper(rule);
            rule.setParentGroupId(groupId);
            this.markRuleAsDirty(wrule);
            this.rules.put(rule.getId(), wrule);
            List<ParsingRuleDTOWrapper> get = this.rulesForGroup.get(groupId);
            if (get == null) {
                get = new ArrayList<ParsingRuleDTOWrapper>();
            }
            get.add(wrule);
            this.rulesForGroup.put(groupId, get);
            ParsingRulesGroupDTOWrapper parentGroup = this.groups.get(rule.getParentGroupId());
            if (!parentGroup.getRuleIds().contains(rule.getId())) {
                parentGroup.getRuleIds().add(rule.getId());
            }
            this.pcs.firePropertyChange(PROP_RULE_ADDED, "", rule);
        }
    }

    public void addRule(ParsingRuleDTOWrapper rule) {
        this.markRuleAsDirty(rule);
        this.rules.put(rule.getId(), rule);
        List<ParsingRuleDTOWrapper> get = this.rulesForGroup.get(rule.getParentGroupId());
        if (get == null) {
            get = new ArrayList<ParsingRuleDTOWrapper>();
        }
        get.add(rule);
        this.rulesForGroup.put(rule.getParentGroupId(), get);
        ParsingRulesGroupDTOWrapper parentGroup = this.groups.get(rule.getParentGroupId());
        if (parentGroup != null) {
            if (!parentGroup.getRuleIds().contains(rule.getId())) {
                parentGroup.getRuleIds().add(rule.getId());
            }
            this.pcs.firePropertyChange(PROP_RULE_ADDED, "", rule);
        }
    }

    public void addRules(List<ParsingRuleDTOWrapper> rules) {
        for (ParsingRuleDTOWrapper rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRuleSet() {
        ParsingRuleSetDTO ruleSet = new ParsingRuleSetDTO();
        ParsingRuleSetDTOWrapper ruleSetWrap = new ParsingRuleSetDTOWrapper(ruleSet);
        this.markRuleSetAsDirty(ruleSetWrap);
        ruleSet.setId(this.generateId());
        ruleSet.setName(NbBundle.getMessage(RuleSetModel.class, (String)"NewItemName.title"));
        ruleSet.setDescription("");
        this.rulesets.put(ruleSet.getId(), ruleSetWrap);
        this.pcs.firePropertyChange(PROP_RULESET_ADD, null, ruleSetWrap);
    }

    public void addRuleSet(ParsingRuleSetDTOWrapper ruleSet) {
        this.markRuleSetAsDirty(ruleSet);
        this.rulesets.put(ruleSet.getId(), ruleSet);
        this.pcs.firePropertyChange(PROP_RULESET_ADD, null, ruleSet);
    }

    public void addTestCase(ParsingRuleDTOWrapper rule, RawLog rawlog) {
        if (rule != null) {
            ParsingRuleTestCase tc = new ParsingRuleTestCase();
            tc.setId(this.generateId());
            tc.setRawLog(rawlog);
            tc.setChecks(new ParsingRuleTestCase.Checks());
            rule.addTestCase(tc);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void addTestCaseCheck(ParsingRuleDTOWrapper rule, ParsingRuleTestCase testCase, String category, String key, String value, boolean mustMatch) {
        if (rule != null && testCase != null) {
            ParsingRuleTestCaseCheck check = new ParsingRuleTestCaseCheck();
            check.setCategory(category);
            check.setKey(key);
            check.setRegexp(value);
            check.setId(UUID.randomUUID().toString());
            if (mustMatch) {
                check.setType(ParsingRuleTestCaseCheckType.MUST_MATCH);
            } else {
                check.setType(ParsingRuleTestCaseCheckType.MUST_NOT_MATCH);
            }
            if (testCase.getChecks() == null) {
                testCase.setChecks(new ParsingRuleTestCase.Checks());
            }
            List<ParsingRuleTestCase.Checks.Entry> entries = testCase.getChecks().getEntry() == null ? new ArrayList() : testCase.getChecks().getEntry();
            ParsingRuleTestCase.Checks.Entry entry = new ParsingRuleTestCase.Checks.Entry();
            entry.setKey(check.getId());
            entry.setValue(check);
            entries.add(entry);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void clearAllMaps() {
        this.rulesets.clear();
        this.groups.clear();
        this.groupsForParent.clear();
        this.rules.clear();
        this.rulesForGroup.clear();
        this.copyrulesets.clear();
        this.copygroups.clear();
        this.copygroupsForParent.clear();
        this.copyrules.clear();
        this.copyrulesForGroup.clear();
    }

    public void clearAllMaps2() {
        this.rulesets = new HashMap<String, ParsingRuleSetDTOWrapper>();
        this.groups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
        this.groupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
        this.rules = new HashMap<String, ParsingRuleDTOWrapper>();
        this.rulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
        this.copyrulesets = new HashMap<String, ParsingRuleSetDTOWrapper>();
        this.copygroups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
        this.copygroupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
        this.copyrules = new HashMap<String, ParsingRuleDTOWrapper>();
        this.copyrulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
    }

    public void commitChanges() {
        ArrayList<ParsingRuleDTO> dirtyRules = new ArrayList<ParsingRuleDTO>();
        ArrayList<ParsingRuleDTOWrapper> wDirtyRules = new ArrayList<ParsingRuleDTOWrapper>();
        ArrayList<ParsingRuleDTO> deleteRules = new ArrayList<ParsingRuleDTO>();
        for (ParsingRuleDTOWrapper r : this.rules.values()) {
            if (r.isDirty()) {
                dirtyRules.add(r.getRule());
                wDirtyRules.add(r);
                LOGGER.info(String.format("Changed rule '%s' %s, pg id: %s", r.getDescription(), r.getId(), r.getParentGroupId()));
                continue;
            }
            if (!r.isForDelete()) continue;
            deleteRules.add(r.getRule());
            LOGGER.info(String.format("Deleted rule '%s' %s, pg id: %s", r.getDescription(), r.getId(), r.getParentGroupId()));
        }
        ArrayList<ParsingRulesGroupDTO> dirtyGroups = new ArrayList<ParsingRulesGroupDTO>();
        ArrayList<ParsingRulesGroupDTOWrapper> wDirtyGroups = new ArrayList<ParsingRulesGroupDTOWrapper>();
        ArrayList<ParsingRulesGroupDTO> deleteGroups = new ArrayList<ParsingRulesGroupDTO>();
        for (ParsingRulesGroupDTOWrapper g : this.groups.values()) {
            g.setParentId(this.getParentIdForGroupId(g.getId()));
            if (g.isDirty()) {
                dirtyGroups.add(g.getGroup());
                wDirtyGroups.add(g);
                LOGGER.info(String.format("Changed group '%s' %s, p id: %s", g.getName(), g.getId(), g.getParentId()));
                LOGGER.info(String.format("     RuleIds: %s", g.getRuleIds()));
                LOGGER.info(String.format("     GroupIds: %s", g.getGroupIds()));
                boolean contains = false;
                ParsingRulesGroupDTOWrapper parentGroup = this.groups.get(g.getParentId());
                if (parentGroup != null) {
                    contains = parentGroup.getGroupIds().contains(g.getId());
                } else {
                    ParsingRuleSetDTOWrapper parentRuleSet = this.rulesets.get(g.getParentId());
                    contains = parentRuleSet.getGroupIds().contains(g.getId());
                }
                LOGGER.info(String.format("     Parent contains it: %s", contains));
                continue;
            }
            if (!g.isForDelete()) continue;
            deleteGroups.add(g.getGroup());
            LOGGER.info(String.format("Deleted group '%s' %s, p id: %s", g.getName(), g.getId(), g.getParentId()));
        }
        ArrayList<ParsingRuleSetDTO> dirtyRuleSets = new ArrayList<ParsingRuleSetDTO>();
        ArrayList<ParsingRuleSetDTOWrapper> wDirtyRuleSets = new ArrayList<ParsingRuleSetDTOWrapper>();
        ArrayList<ParsingRuleSetDTO> deleteRuleSets = new ArrayList<ParsingRuleSetDTO>();
        for (ParsingRuleSetDTOWrapper rs : this.rulesets.values()) {
            if (rs.isDirty()) {
                dirtyRuleSets.add(rs.getRuleset());
                wDirtyRuleSets.add(rs);
                LOGGER.info(String.format("Changed ruleset '%s' %s", rs.getName(), rs.getId()));
                continue;
            }
            if (!rs.isForDelete()) continue;
            deleteRuleSets.add(rs.getRuleset());
            LOGGER.info(String.format("Deleted ruleset '%s' %s", rs.getName(), rs.getId()));
        }
        try {
            ParsingUpdateObjectDTO puo = new ParsingUpdateObjectDTO();
            puo.getDirtyRuleSets().addAll(dirtyRuleSets);
            puo.getDeleteRuleSets().addAll(deleteRuleSets);
            puo.getDirtyGroups().addAll(dirtyGroups);
            puo.getDeleteGroups().addAll(deleteGroups);
            puo.getDirtyRules().addAll(dirtyRules);
            puo.getDeleteRules().addAll(deleteRules);
            this.apiService.saveChanges(puo);
            this.resetRuleSetsDirtyFlags(wDirtyRuleSets);
            this.resetGroupsDirtyFlags(wDirtyGroups);
            this.resetRulesDirtyFlags(wDirtyRules);
            this.clearAllMaps2();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void copyRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper ruleToCopy) {
        if (group != null && ruleToCopy != null) {
            ParsingRuleDTOWrapper copyRule = this.duplicateRule(ruleToCopy);
            this.markRuleAsDirty(copyRule);
            this.rules.put(copyRule.getId(), copyRule);
            List<ParsingRuleDTOWrapper> get = this.rulesForGroup.get(group.getId());
            if (get == null) {
                get = new ArrayList<ParsingRuleDTOWrapper>();
            }
            get.add(copyRule);
            this.rulesForGroup.put(group.getId(), get);
            group.getRuleIds().add(copyRule.getId());
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", copyRule);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, "", group);
        }
    }

    public Map<String, RegressionTestResult> createRegressionTestResultsMap() throws ApiServiceException_Exception {
        HashMap<String, RegressionTestResult> map = new HashMap<String, RegressionTestResult>();
        try {
            List<RegressionTestResult> results = this.getRegressionTestResults();
            for (RegressionTestResult r : results) {
                map.put(r.getRuleId(), r);
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public List<ParsingRulesGroupDTOWrapper> getAllGroups() {
        try {
            this.rgc = new RulesGroupCallable(null);
            this.submitGroups = this.executor.submit(this.rgc);
            ArrayList<ParsingRulesGroupDTOWrapper> ret = new ArrayList<ParsingRulesGroupDTOWrapper>();
            List<ParsingRulesGroupDTO> all = this.submitGroups.get();
            for (ParsingRulesGroupDTO g : all) {
                ParsingRulesGroupDTOWrapper gw = new ParsingRulesGroupDTOWrapper(g);
                ret.add(gw);
            }
            return ret;
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public List<ParsingRuleDTOWrapper> getAllRules() {
        try {
            this.rc = new RulesCallable(null);
            this.submitRules = this.executor.submit(this.rc);
            ArrayList<ParsingRuleDTOWrapper> ret = new ArrayList<ParsingRuleDTOWrapper>();
            List<ParsingRuleDTO> all = this.submitRules.get();
            for (ParsingRuleDTO r : all) {
                ParsingRuleDTOWrapper rw = new ParsingRuleDTOWrapper(r);
                ret.add(rw);
            }
            return ret;
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public ParsingRulesGroupDTOWrapper getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public ParsingRulesGroupDTOWrapper getGroupForRuleId(String ruleId) {
        for (ParsingRulesGroupDTOWrapper g : this.groups.values()) {
            for (ParsingRuleDTOWrapper r : this.rulesForGroup.get(g.getId())) {
                if (!r.getId().equals(ruleId)) continue;
                return g;
            }
        }
        return null;
    }

    public List<ParsingRulesGroupDTOWrapper> getGroupsForParent(String parentId, boolean force) throws InterruptedException, ExecutionException {
        List<ParsingRulesGroupDTOWrapper> r = this.groupsForParent.get(parentId);
        LOGGER.info(String.format("getGroupsForParent r == null is %s and force is %s", r == null, force));
        if (r == null || r.isEmpty() || force) {
            this.rgc = new RulesGroupCallable(parentId);
            this.submitGroups = this.executor.submit(this.rgc);
            List<ParsingRulesGroupDTO> get = this.submitGroups.get();
            LOGGER.info(String.format("getGroupsForParent Got %d groups for parent id %s", get.size(), parentId));
            ArrayList<ParsingRulesGroupDTOWrapper> wget = new ArrayList<ParsingRulesGroupDTOWrapper>();
            ArrayList<ParsingRulesGroupDTOWrapper> cwget = new ArrayList<ParsingRulesGroupDTOWrapper>();
            for (ParsingRulesGroupDTO g : get) {
                if (this.groups.containsKey(g.getId()) && !force) continue;
                ParsingRulesGroupDTOWrapper w = new ParsingRulesGroupDTOWrapper(g);
                this.groups.put(g.getId(), w);
                ParsingRulesGroupDTOWrapper cw = DeepObjectCopy.copyParsingRulesGroupDTOW(g);
                this.copygroups.put(parentId, cw);
                if (!cw.getParentId().equals(parentId)) continue;
                wget.add(w);
                cwget.add(cw);
            }
            if (!wget.isEmpty()) {
                this.groupsForParent.put(parentId, wget);
                this.copygroupsForParent.put(parentId, cwget);
            }
            r = wget;
        }
        LOGGER.info(String.format("getGroupsForParent Returning %d groups for parent id %s", r.size(), parentId));
        return r;
    }

    public Map<String, List<String>> getMappings() {
        try {
            return this.apiService.getMappings();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_MAP;
        }
    }

    public List<String> getMappingsForCategory(String category) {
        try {
            return this.apiService.getMappingsForCategory(category);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public String getParentIdForGroupId(String groupId) {
        if (!this.groupsForParent.isEmpty()) {
            for (String parentId : this.groupsForParent.keySet()) {
                List<ParsingRulesGroupDTOWrapper> list = this.groupsForParent.get(parentId);
                for (ParsingRulesGroupDTOWrapper g : list) {
                    if (!g.getId().equals(groupId)) continue;
                    return parentId;
                }
            }
        }
        return null;
    }

    public List<RegressionTestResult> getRegressionTestResults() throws ApiServiceException_Exception {
        return this.apiService.regressionTest();
    }

    public ParsingRuleDTOWrapper getRule(String id) {
        for (ParsingRuleDTOWrapper r : this.rules.values()) {
            if (!r.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    public Collection<ParsingRuleSetDTOWrapper> getRuleSets() {
        try {
            if (this.rulesets.isEmpty()) {
                this.rsc = new RuleSetCallable();
                this.submitRuleSets = this.executor.submit(this.rsc);
                Collection get = this.submitRuleSets.get();
                for (ParsingRuleSetDTO rs : get) {
                    ParsingRuleSetDTOWrapper w = new ParsingRuleSetDTOWrapper(rs);
                    this.rulesets.put(w.getId(), w);
                    ParsingRuleSetDTOWrapper cw = DeepObjectCopy.copyParsingRuleSetDTOW(rs);
                    this.copyrulesets.put(w.getId(), cw);
                }
            }
            return this.rulesets.values();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public List<ParsingRuleDTOWrapper> getRulesForGroup(String groupId) {
        try {
            List<ParsingRuleDTOWrapper> p = this.rulesForGroup.get(groupId);
            if (p == null) {
                this.rc = new RulesCallable(groupId);
                this.submitRules = this.executor.submit(this.rc);
                List<ParsingRuleDTO> get = this.submitRules.get();
                ArrayList<ParsingRuleDTOWrapper> wget = new ArrayList<ParsingRuleDTOWrapper>();
                ArrayList<ParsingRuleDTOWrapper> cwget = new ArrayList<ParsingRuleDTOWrapper>();
                for (ParsingRuleDTO r : get) {
                    if (this.rules.containsKey(r.getId())) continue;
                    ParsingRuleDTOWrapper w = new ParsingRuleDTOWrapper(r);
                    this.rules.put(r.getId(), w);
                    ParsingRuleDTOWrapper cw = DeepObjectCopy.copyParsingRuleDTOW(r);
                    this.copyrules.put(r.getId(), cw);
                    wget.add(w);
                    cwget.add(cw);
                }
                this.rulesForGroup.put(groupId, wget);
                this.copyrulesForGroup.put(groupId, cwget);
                p = wget;
            }
            return p;
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean mode) {
        this.editMode = mode;
        this.pcs.firePropertyChange(PROP_EDITMODE_CHANGED, "", (Object)this.editMode);
    }

    public void markRuleAsDirty(ParsingRuleDTOWrapper rule) {
        if (!rule.isForDelete()) {
            rule.setDirty(true);
        } else {
            LOGGER.log(Level.INFO, "Rule is marked for delete therefore can not be marked as dirty too!");
        }
    }

    public String modelDump() {
        ParsingRuleDTOWrapper r;
        List<ParsingRuleDTOWrapper> rlist;
        ParsingRulesGroupDTOWrapper g;
        List<ParsingRulesGroupDTOWrapper> glist;
        ParsingRuleSetDTOWrapper rs;
        StringBuilder sb = new StringBuilder();
        sb.append("RULESETS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.rulesets.keySet()) {
            rs = this.rulesets.get(key);
            sb.append(String.format(" %s, %s", rs.getName(), rs.getId()));
            sb.append(System.getProperty("line.separator"));
            if (rs.getGroupIds().isEmpty()) continue;
            sb.append("       Child groups:");
            sb.append(System.getProperty("line.separator"));
            for (String gid : rs.getGroupIds()) {
                sb.append(String.format("         %s", gid));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("COPY RULESETS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.copyrulesets.keySet()) {
            rs = this.copyrulesets.get(key);
            sb.append(String.format(" %s, %s", rs.getName(), rs.getId()));
            sb.append(System.getProperty("line.separator"));
            if (rs.getGroupIds().isEmpty()) continue;
            sb.append("       Child groups:");
            for (String gid : rs.getGroupIds()) {
                sb.append(String.format("         %s", gid));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("GROUPS FOR PARENTS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.groupsForParent.keySet()) {
            sb.append(String.format("Group parent: %s", key));
            sb.append(System.getProperty("line.separator"));
            glist = this.groupsForParent.get(key);
            for (ParsingRulesGroupDTOWrapper g2 : glist) {
                sb.append(String.format("       %s, id: %s, pid: %s", g2.getName(), g2.getId(), g2.getParentId()));
                sb.append(System.getProperty("line.separator"));
                if (!g2.getGroupIds().isEmpty()) {
                    sb.append("       Child group ids:");
                    sb.append(System.getProperty("line.separator"));
                    for (String gid : g2.getGroupIds()) {
                        sb.append(String.format("         %s", gid));
                        sb.append(System.getProperty("line.separator"));
                    }
                }
                if (g2.getRuleIds().isEmpty()) continue;
                sb.append("       Child rule ids:");
                sb.append(System.getProperty("line.separator"));
                for (String rid : g2.getRuleIds()) {
                    sb.append(String.format("         %s", rid));
                    sb.append(System.getProperty("line.separator"));
                }
            }
        }
        sb.append("COPY GROUPS FOR PARENTS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.copygroupsForParent.keySet()) {
            sb.append(String.format("Group parent: %s", key));
            sb.append(System.getProperty("line.separator"));
            glist = this.copygroupsForParent.get(key);
            for (ParsingRulesGroupDTOWrapper g2 : glist) {
                sb.append(String.format("       %s, id: %s, pid: %s", g2.getName(), g2.getId(), g2.getParentId()));
                sb.append(System.getProperty("line.separator"));
                if (!g2.getGroupIds().isEmpty()) {
                    sb.append("       Child group ids:");
                    sb.append(System.getProperty("line.separator"));
                    for (String gid : g2.getGroupIds()) {
                        sb.append(String.format("         %s", gid));
                        sb.append(System.getProperty("line.separator"));
                    }
                }
                if (g2.getRuleIds().isEmpty()) continue;
                sb.append("       Child rule ids:");
                sb.append(System.getProperty("line.separator"));
                for (String rid : g2.getRuleIds()) {
                    sb.append(String.format("         %s", rid));
                    sb.append(System.getProperty("line.separator"));
                }
            }
        }
        sb.append("GROUPS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.groups.keySet()) {
            g = this.groups.get(key);
            sb.append(String.format("%s, id: %s, pid: %s", g.getName(), g.getId(), g.getParentId()));
            sb.append(System.getProperty("line.separator"));
            if (!g.getGroupIds().isEmpty()) {
                sb.append("       Child group ids:");
                sb.append(System.getProperty("line.separator"));
                for (String gid : g.getGroupIds()) {
                    sb.append(String.format("         %s", gid));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (g.getRuleIds().isEmpty()) continue;
            sb.append("       Child rule ids:");
            sb.append(System.getProperty("line.separator"));
            for (String rid : g.getRuleIds()) {
                sb.append(String.format("         %s", rid));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("COPY GROUPS");
        sb.append(System.getProperty("line.separator"));
        for (String key : this.copygroups.keySet()) {
            g = this.copygroups.get(key);
            sb.append(String.format("%s, id: %s, pid: %s", g.getName(), g.getId(), g.getParentId()));
            sb.append(System.getProperty("line.separator"));
            if (!g.getGroupIds().isEmpty()) {
                sb.append("       Child group ids:");
                sb.append(System.getProperty("line.separator"));
                for (String gid : g.getGroupIds()) {
                    sb.append(String.format("         %s", gid));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (g.getRuleIds().isEmpty()) continue;
            sb.append("       Child rule ids:");
            sb.append(System.getProperty("line.separator"));
            for (String rid : g.getRuleIds()) {
                sb.append(String.format("         %s", rid));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("RULES FOR GROUP");
        sb.append(System.getProperty("line.separator"));
        for (String gid : this.rulesForGroup.keySet()) {
            sb.append(String.format("Parent group id: %s", gid));
            sb.append(System.getProperty("line.separator"));
            if (this.rulesForGroup.get(gid).isEmpty()) continue;
            sb.append("       Child rules:");
            sb.append(System.getProperty("line.separator"));
            rlist = this.rulesForGroup.get(gid);
            for (ParsingRuleDTOWrapper r2 : rlist) {
                sb.append(String.format("       %s, %s", r2.getDescription(), r2.getId()));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("COPY RULES FOR GROUP");
        sb.append(System.getProperty("line.separator"));
        for (String gid : this.copyrulesForGroup.keySet()) {
            sb.append(String.format("Parent group id: %s", gid));
            sb.append(System.getProperty("line.separator"));
            if (this.copyrulesForGroup.get(gid).isEmpty()) continue;
            sb.append("       Child rules:");
            sb.append(System.getProperty("line.separator"));
            rlist = this.copyrulesForGroup.get(gid);
            for (ParsingRuleDTOWrapper r2 : rlist) {
                sb.append(String.format("       %s, %s", r2.getDescription(), r2.getId()));
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("RULES");
        sb.append(System.getProperty("line.separator"));
        for (String rid : this.rules.keySet()) {
            r = this.rules.get(rid);
            sb.append(String.format("%s, id: %s, pid: %s", r.getDescription(), r.getId(), r.getParentGroupId()));
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("COPY RULES");
        sb.append(System.getProperty("line.separator"));
        for (String rid : this.copyrules.keySet()) {
            r = this.copyrules.get(rid);
            sb.append(String.format("%s, id: %s, pid: %s", r.getDescription(), r.getId(), r.getParentGroupId()));
            sb.append(System.getProperty("line.separator"));
        }
        String name = "";
        try {
            name = String.format("%s/modeldump_%d.dmp", System.getProperty("netbeans.user"), System.currentTimeMillis());
            LOGGER.info(String.format("Model dumped to %s", name));
            Files.write(Paths.get(name, new String[0]), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return name;
    }

    public void moveDownRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        List<ParsingRuleDTOWrapper> list = this.rulesForGroup.get(group.getId());
        ArrayList<ParsingRuleDTOWrapper> cList = new ArrayList<ParsingRuleDTOWrapper>(list);
        int i = cList.indexOf(rule);
        int ii = i + 1;
        if (ii < cList.size()) {
            ParsingRuleDTOWrapper belowRule = (ParsingRuleDTOWrapper)cList.get(ii);
            cList.set(i, belowRule);
            cList.set(ii, rule);
            LOGGER.info(String.format("MoveDown: %s", cList));
            this.setRulesForGroup(group.getId(), cList);
        }
    }

    public void moveUpRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        List<ParsingRuleDTOWrapper> list = this.rulesForGroup.get(group.getId());
        ArrayList<ParsingRuleDTOWrapper> cList = new ArrayList<ParsingRuleDTOWrapper>(list);
        int i = cList.indexOf(rule);
        int ii = i - 1;
        if (ii >= 0) {
            ParsingRuleDTOWrapper aboveRule = (ParsingRuleDTOWrapper)cList.get(ii);
            cList.set(i, aboveRule);
            cList.set(ii, rule);
            LOGGER.info(String.format("MoveUp: %s", cList));
            this.setRulesForGroup(group.getId(), cList);
        }
    }

    public void refreshGroup(ParsingRulesGroupDTOWrapper group) {
        this.groupsForParent.remove(group.getId());
        this.groups.remove(group.getId());
        for (String gid : group.getGroupIds()) {
            this.groups.remove(gid);
        }
        this.rulesForGroup.remove(group.getId());
        for (String rid : group.getRuleIds()) {
            this.rules.remove(rid);
        }
        try {
            this.getGroupsForParent(group.getId(), true);
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void removeAssignment(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment) {
        if (rule != null && assignment != null) {
            rule.removeAssignment(assignment);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removeGroup(String groupId) {
        String parentId = this.getParentIdForGroupId(groupId);
        ParsingRulesGroupDTOWrapper oldGroup = this.groups.get(groupId);
        this.markGroupForDelete(oldGroup);
        if (this.groupsForParent.containsKey(parentId)) {
            List<ParsingRulesGroupDTOWrapper> get = this.groupsForParent.get(parentId);
            for (ParsingRulesGroupDTOWrapper g : get) {
                if (!g.getId().equals(groupId)) continue;
                g.setForDelete(true);
                this.recursion(groupId);
                List<ParsingRuleDTOWrapper> get1 = this.rulesForGroup.get(g.getId());
                for (ParsingRuleDTOWrapper r : get1) {
                    r.setForDelete(true);
                }
            }
            this.pcs.firePropertyChange(PROP_GROUP_REMOVED, oldGroup, null);
        }
    }

    public void removeMetaRule(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule) {
        if (rule != null && metaRule != null) {
            rule.removeMetaRule(metaRule);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removeRule(ParsingRulesGroupDTOWrapper group, ParsingRuleDTOWrapper rule) {
        if (group != null && rule != null) {
            this.markRuleForDelete(rule);
            group.getRuleIds().remove(rule.getId());
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_RULE_REMOVED, rule, null);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, "", group);
        }
    }

    public void removeRuleSet(String ruleSetId) {
        ParsingRuleSetDTOWrapper oldRuleSet = this.rulesets.get(ruleSetId);
        this.markRuleSetForDelete(oldRuleSet);
        if (this.groupsForParent.containsKey(ruleSetId)) {
            this.recursion(ruleSetId);
        }
        this.pcs.firePropertyChange(PROP_RULESET_REMOVED, oldRuleSet, null);
    }

    public void removeTestCase(ParsingRuleDTOWrapper rule, ParsingRuleTestCase testCase) {
        if (rule != null && testCase != null) {
            rule.removeTestCase(testCase);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void removeTestCaseCheck(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check) {
        if (rule != null && check != null) {
            List<ParsingRuleTestCase> testCases = rule.getTestCases();
            for (ParsingRuleTestCase tc : testCases) {
                ArrayList<ParsingRuleTestCase.Checks.Entry> forDelete = new ArrayList<ParsingRuleTestCase.Checks.Entry>();
                List entry = tc.getChecks().getEntry();
                for (ParsingRuleTestCase.Checks.Entry n : entry) {
                    if (!check.getId().equals(n.getKey())) continue;
                    forDelete.add(n);
                }
                entry.removeAll(forDelete);
            }
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void reset() {
        ArrayList<Object> cget;
        List<Object> get;
        this.clearMaps2();
        for (ParsingRuleSetDTOWrapper rs : this.copyrulesets.values()) {
            ParsingRuleSetDTOWrapper copyRuleSet = DeepObjectCopy.copyParsingRuleSetDTOW(rs.getRuleset());
            this.rulesets.put(copyRuleSet.getId(), copyRuleSet);
        }
        for (String parentId : this.copygroupsForParent.keySet()) {
            get = this.copygroupsForParent.get(parentId);
            cget = new ArrayList<Object>();
            for (ParsingRulesGroupDTOWrapper parsingRulesGroupDTOWrapper : get) {
                ParsingRulesGroupDTOWrapper copyGroup = DeepObjectCopy.copyParsingRulesGroupDTOW(parsingRulesGroupDTOWrapper.getGroup());
                this.groups.put(parsingRulesGroupDTOWrapper.getId(), copyGroup);
                cget.add(copyGroup);
            }
            this.groupsForParent.put(parentId, cget);
        }
        for (String groupId : this.copyrulesForGroup.keySet()) {
            get = this.copyrulesForGroup.get(groupId);
            cget = new ArrayList();
            for (ParsingRuleDTOWrapper parsingRuleDTOWrapper : get) {
                ParsingRuleDTOWrapper copyRule = DeepObjectCopy.copyParsingRuleDTOW(parsingRuleDTOWrapper.getRule());
                this.rules.put(copyRule.getId(), copyRule);
                cget.add(copyRule);
            }
            this.rulesForGroup.put(groupId, cget);
        }
    }

    public void setAssignmentCategory(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String category) {
        if (rule != null && assignment != null && !assignment.getCategory().equals(category)) {
            assignment.setCategory(category);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setAssignmentKey(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String key) {
        if (rule != null && assignment != null && !(assignment.getKey() != null ? assignment.getKey() : "").equals(key)) {
            assignment.setKey(key);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setAssignmentValue(ParsingRuleDTOWrapper rule, ParsingRuleAssignment assignment, String value) {
        if (rule != null && assignment != null && !(assignment.getValue() != null ? assignment.getValue() : "").equals(value)) {
            assignment.setValue(value);
            assignment.setMatchGroupNumber(null);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setGroupName(ParsingRulesGroupDTOWrapper group, String newName) {
        group.setName(newName);
        group.setDirty(true);
        this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, group);
    }

    public void setMetaRuleActive(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule, boolean active) {
        if (rule != null && metaRule != null) {
            metaRule.setActive(Boolean.valueOf(active));
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setMetaRuleExpression(ParsingRuleDTOWrapper rule, ParsingRuleMetaRule metaRule, String expression) {
        if (rule != null && metaRule != null && !metaRule.getRuleEL().equals(expression)) {
            metaRule.setRuleEL(expression);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setRuleContinueParsing(ParsingRuleDTOWrapper rule, boolean continueParsing) {
        rule.setContinueParsing(continueParsing);
        rule.setSilent(false);
        rule.setMatchedGroupId(null);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void setRuleDescription(ParsingRuleDTOWrapper rule, String desc) {
        if (!rule.getDescription().equals(desc)) {
            rule.setDescription(desc);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setRuleJumpTo(ParsingRuleDTOWrapper rule, String jumpToGroupId) {
        rule.setMatchedGroupId(jumpToGroupId);
        rule.setContinueParsing(false);
        rule.setSilent(false);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void setRuleRegexp(ParsingRuleDTOWrapper rule, String regexp) {
        if (rule.getRegexp() == null) {
            rule.setRegexp("");
        }
        if (!rule.getRegexp().equals(regexp)) {
            rule.setRegexp(regexp);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setRuleSetName(ParsingRuleSetDTOWrapper ruleSet, String newName) {
        ruleSet.setName(newName);
        ruleSet.setDirty(true);
        this.pcs.firePropertyChange(PROP_RULESET_CHANGED, null, ruleSet);
    }

    public void setRuleSilent(ParsingRuleDTOWrapper rule, boolean silent) {
        rule.setSilent(silent);
        rule.setContinueParsing(false);
        rule.setMatchedGroupId(null);
        this.markRuleAsDirty(rule);
        this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
    }

    public void setRulesForGroup(String groupId, List<ParsingRuleDTOWrapper> rules) {
        this.rulesForGroup.get(groupId).clear();
        this.rulesForGroup.get(groupId).addAll(rules);
        ParsingRulesGroupDTOWrapper group = this.groups.get(groupId);
        if (group != null) {
            if (group.getRuleIds() != null) {
                group.getRuleIds().clear();
            } else {
                group.setRuleIds(new ArrayList<String>());
            }
            for (ParsingRuleDTOWrapper r : rules) {
                group.getRuleIds().add(r.getId());
            }
            this.markGroupAsDirty(group);
            this.pcs.firePropertyChange(PROP_GROUP_CHANGED, null, group);
        } else {
            LOGGER.warning(String.format("Group %s is null!", groupId));
        }
    }

    public void setTestCaseCheckCategory(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check, String category) {
        if (rule != null && check != null) {
            check.setCategory(category);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setTestCaseCheckKey(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check, String key) {
        if (rule != null && check != null) {
            check.setKey(key);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setTestCaseCheckType(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check, ParsingRuleTestCaseCheckType type) {
        if (rule != null && check != null) {
            check.setType(type);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void setTestCaseCheckValue(ParsingRuleDTOWrapper rule, ParsingRuleTestCaseCheck check, String value) {
        if (rule != null && check != null) {
            check.setRegexp(value);
            this.markRuleAsDirty(rule);
            this.pcs.firePropertyChange(PROP_RULE_CHANGED, "", rule);
        }
    }

    public void toggleEditMode() {
        this.editMode = !this.editMode;
        this.pcs.firePropertyChange(PROP_EDITMODE_CHANGED, "", (Object)this.editMode);
    }

    private void clearMaps2() {
        this.rulesets = new HashMap<String, ParsingRuleSetDTOWrapper>();
        this.groups = new HashMap<String, ParsingRulesGroupDTOWrapper>();
        this.groupsForParent = new HashMap<String, List<ParsingRulesGroupDTOWrapper>>();
        this.rules = new HashMap<String, ParsingRuleDTOWrapper>();
        this.rulesForGroup = new HashMap<String, List<ParsingRuleDTOWrapper>>();
    }

    private ParsingRuleSetDTOWrapper duplicateRuleSet(ParsingRuleSetDTOWrapper ruleSet, List<ParsingRulesGroupDTOWrapper> groupsToAdd) throws InterruptedException, ExecutionException {
        ParsingRuleSetDTO copyRuleSet = new ParsingRuleSetDTO();
        copyRuleSet.setId(UUID.randomUUID().toString());
        copyRuleSet.setDescription(ruleSet.getDescription());
        copyRuleSet.setName(ruleSet.getName());
        copyRuleSet.setVersion(ruleSet.getVersion());
        ParsingRuleSetDTOWrapper copyRuleSetWrapper = new ParsingRuleSetDTOWrapper(copyRuleSet);
        List<ParsingRulesGroupDTOWrapper> ogroups = this.getGroupsForParent(ruleSet.getId(), false);
        for (ParsingRulesGroupDTOWrapper g : ogroups) {
            ParsingRulesGroupDTOWrapper cg = this.duplicateGroup(g, copyRuleSet.getId(), groupsToAdd);
            copyRuleSet.getGroupIds().add(cg.getId());
        }
        this.addRuleSet(copyRuleSetWrapper);
        return copyRuleSetWrapper;
    }

    public void duplicateRuleSet(ParsingRuleSetDTOWrapper ruleSet) throws InterruptedException, ExecutionException {
        ArrayList<ParsingRulesGroupDTOWrapper> groupsToAdd = new ArrayList<ParsingRulesGroupDTOWrapper>();
        ParsingRuleSetDTOWrapper duplicateRuleSet = this.duplicateRuleSet(ruleSet, groupsToAdd);
        this.addGroups(groupsToAdd);
    }

    private ParsingRulesGroupDTOWrapper duplicateGroup(ParsingRulesGroupDTOWrapper group, String parentId, List<ParsingRulesGroupDTOWrapper> groupsToAdd) throws InterruptedException, ExecutionException {
        ParsingRulesGroupDTO copyGroup = new ParsingRulesGroupDTO();
        copyGroup.setId(UUID.randomUUID().toString());
        copyGroup.setDescription(group.getDescription());
        copyGroup.setName(group.getName());
        copyGroup.setParentId(parentId);
        ParsingRulesGroupDTOWrapper copyGroupWrapper = new ParsingRulesGroupDTOWrapper(copyGroup);
        groupsToAdd.add(copyGroupWrapper);
        List<ParsingRulesGroupDTOWrapper> ogroups = this.getGroupsForParent(group.getId(), false);
        for (ParsingRulesGroupDTOWrapper g : ogroups) {
            ParsingRulesGroupDTOWrapper cg = this.duplicateGroup(g, copyGroup.getId(), groupsToAdd);
            copyGroup.getGroupIds().add(cg.getId());
        }
        List<ParsingRuleDTOWrapper> orules = this.getRulesForGroup(group.getId());
        ArrayList<ParsingRuleDTOWrapper> copyRules = new ArrayList<ParsingRuleDTOWrapper>();
        for (ParsingRuleDTOWrapper rule : orules) {
            ParsingRuleDTOWrapper copyRule = this.duplicateRule(rule);
            copyRule.setParentGroupId(copyGroup.getId());
            copyGroup.getRuleIds().add(copyRule.getId());
            copyRules.add(copyRule);
        }
        this.addRules(copyRules);
        return copyGroupWrapper;
    }

    public void duplicateGroup(ParsingRulesGroupDTOWrapper group, String parentId) throws InterruptedException, ExecutionException {
        ArrayList<ParsingRulesGroupDTOWrapper> groupsToAdd = new ArrayList<ParsingRulesGroupDTOWrapper>();
        ParsingRulesGroupDTOWrapper duplicateGroup = this.duplicateGroup(group, parentId, groupsToAdd);
        this.addGroups(groupsToAdd);
    }

    private ParsingRuleDTOWrapper duplicateRule(ParsingRuleDTOWrapper rule) {
        ParsingRuleDTO copyRule = new ParsingRuleDTO();
        copyRule.setContinueParsing(rule.isContinueParsing());
        copyRule.setDescription(rule.getDescription());
        copyRule.setId(UUID.randomUUID().toString());
        copyRule.setMatchedGroupId(rule.getMatchedGroupId());
        copyRule.setRegexp(rule.getRegexp());
        copyRule.setSilent(rule.isSilent());
        copyRule.setParentGroupId(rule.getParentGroupId());
        for (ParsingRuleAssignment a : rule.getAssignments()) {
            ParsingRuleAssignment copyAssignment = new ParsingRuleAssignment();
            copyAssignment.setCategory(a.getCategory());
            copyAssignment.setId(UUID.randomUUID().toString());
            copyAssignment.setKey(a.getKey());
            copyAssignment.setMatchGroupNumber(a.getMatchGroupNumber());
            copyAssignment.setValue(a.getValue());
            copyRule.getAssignments().add(copyAssignment);
        }
        for (ParsingRuleTestCase t : rule.getTestCases()) {
            ParsingRuleTestCase copyTestCase = new ParsingRuleTestCase();
            copyTestCase.setChecks(t.getChecks());
            copyTestCase.setId(UUID.randomUUID().toString());
            copyTestCase.setRawLog(t.getRawLog());
            copyTestCase.setSecurityEventSilenced(t.isSecurityEventSilenced());
            copyRule.getTestCases().add(copyTestCase);
        }
        for (ParsingRuleMetaRule m : rule.getMetaRules()) {
            ParsingRuleMetaRule copyMetaRule = new ParsingRuleMetaRule();
            copyMetaRule.setActive(m.isActive());
            copyMetaRule.setId(UUID.randomUUID().toString());
            copyMetaRule.setRuleEL(m.getRuleEL());
            copyRule.getMetaRules().add(copyMetaRule);
        }
        ParsingRuleDTOWrapper copyRuleWrapper = new ParsingRuleDTOWrapper(copyRule);
        return copyRuleWrapper;
    }

    public RuleSetBackupContainerDTO exportRuleSets() throws ApiServiceException_Exception {
        RuleSetBackupContainerDTO rsbc = new RuleSetBackupContainerDTO();
        rsbc.getRulesets().addAll(this.apiService.getParsingRuleSets());
        rsbc.getGroups().addAll(this.apiService.getAllParsingRulesGroups());
        rsbc.getRules().addAll(this.apiService.getAllParsingRules());
        return rsbc;
    }

    public void importRuleSets(RuleSetBackupContainerDTO rsbc) throws ApiServiceException_Exception {
        this.apiService.importRuleSets(rsbc);
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    private void markGroupAsDirty(ParsingRulesGroupDTOWrapper group) {
        if (!group.isForDelete()) {
            group.setDirty(true);
        } else {
            LOGGER.log(Level.INFO, "Group is marked for delete therefore can not be marked as dirty too!");
        }
    }

    private void markGroupForDelete(ParsingRulesGroupDTOWrapper group) {
        group.setForDelete(true);
        group.setDirty(false);
    }

    private void markRuleForDelete(ParsingRuleDTOWrapper rule) {
        rule.setForDelete(true);
        rule.setDirty(false);
    }

    private void markRuleSetAsDirty(ParsingRuleSetDTOWrapper ruleSet) {
        if (!ruleSet.isForDelete()) {
            ruleSet.setDirty(true);
        } else {
            LOGGER.log(Level.INFO, "RuleSet is marked for delete therefore can not be marked as dirty too!");
        }
    }

    private void markRuleSetForDelete(ParsingRuleSetDTOWrapper ruleSet) {
        ruleSet.setForDelete(true);
        ruleSet.setDirty(false);
    }

    private void recursion(String parentId) {
        List<ParsingRulesGroupDTOWrapper> get = this.groupsForParent.get(parentId);
        if (get != null) {
            for (ParsingRulesGroupDTOWrapper g : get) {
                g.setForDelete(true);
                this.recursion(g.getId());
                List<ParsingRuleDTOWrapper> get1 = this.rulesForGroup.get(g.getId());
                if (get1 == null) continue;
                for (ParsingRuleDTOWrapper r : get1) {
                    r.setForDelete(true);
                }
            }
        }
    }

    private void resetGroupsDirtyFlags(List<ParsingRulesGroupDTOWrapper> wDirtyGroups) {
        for (ParsingRulesGroupDTOWrapper g : wDirtyGroups) {
            g.setDirty(false);
        }
    }

    private void resetRuleSetsDirtyFlags(List<ParsingRuleSetDTOWrapper> wDirtyRuleSets) {
        for (ParsingRuleSetDTOWrapper rs : wDirtyRuleSets) {
            rs.setDirty(false);
        }
    }

    private void resetRulesDirtyFlags(List<ParsingRuleDTOWrapper> wDirtyRules) {
        for (ParsingRuleDTOWrapper r : wDirtyRules) {
            r.setDirty(false);
        }
    }

    private class RulesGroupCallable
    implements Callable<List<ParsingRulesGroupDTO>> {
        private String parentId;

        public RulesGroupCallable(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public List<ParsingRulesGroupDTO> call() {
            try {
                if (this.parentId != null) {
                    return RuleSetModel.this.apiService.getParsingRulesGroups(this.parentId);
                }
                return RuleSetModel.this.apiService.getAllParsingRulesGroups();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.EMPTY_LIST;
            }
        }
    }

    private class RulesCallable
    implements Callable<List<ParsingRuleDTO>> {
        private String groupId;

        public RulesCallable(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public List<ParsingRuleDTO> call() {
            try {
                if (this.groupId != null) {
                    return RuleSetModel.this.apiService.getParsingRules(this.groupId);
                }
                return RuleSetModel.this.apiService.getAllParsingRules();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.EMPTY_LIST;
            }
        }
    }

    private class RuleSetCallable
    implements Callable<List<ParsingRuleSetDTO>> {
        private RuleSetCallable() {
        }

        @Override
        public List<ParsingRuleSetDTO> call() {
            try {
                return RuleSetModel.this.apiService.getParsingRuleSets();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.EMPTY_LIST;
            }
        }
    }
}

