/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.MultiLevelUpExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLevelUpExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Log log = LogFactory.getLog(MultiLevelUpExpressionEvaluator.class);
    private MultiLevelUpExpression expression;

    public MultiLevelUpExpressionEvaluator(EvaluationContext evaluationContext, MultiLevelUpExpression expression) {
        super(evaluationContext);
        this.expression = expression;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        List<JRJsonNode> nodes = contextNode.getNodes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("---> evaluating expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")"));
        }
        JsonNodeContainer result = new JsonNodeContainer();
        ArrayList<JRJsonNode> uniqueParents = new ArrayList<JRJsonNode>();
        for (JRJsonNode node : nodes) {
            JRJsonNode parent = this.getParent(node);
            if (parent == null || uniqueParents.contains(parent)) continue;
            uniqueParents.add(parent);
            if (!this.applyFilter(parent)) continue;
            result.add(parent);
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private JRJsonNode getParent(JRJsonNode jrJsonNode) {
        JRJsonNode result = jrJsonNode;
        int level = this.expression.getLevel();
        for (int i = 0; i < level; ++i) {
            if ((result = result.getParent()) != null) continue;
            return null;
        }
        return result;
    }
}

