/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByFieldPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByPriorityPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetButtonsPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetSettingsPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetUpdateWorker;

public class OverviewPanel
extends JPanel {
    public static final String FILTER_OUT_QUERY = "FILTER_OUT_QUERY";
    private ExecutorService executor;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private ByPriorityPanel byPriorityPanel;
    private ByFieldPanel byFieldPanelBottom;
    private ByFieldPanel byFieldPanelTop;
    private final String byPriority = NbBundle.getMessage(OverviewPanel.class, (String)"widget.eventsByPriority.title");
    private final String drawingWidget = NbBundle.getMessage(ByPriorityPanel.class, (String)"Widgets.progress.title");
    private WidgetSettingsPanel widgetSettingsPanelTop = new WidgetSettingsPanel();
    private WidgetSettingsPanel widgetSettingsPanelBottom = new WidgetSettingsPanel();
    private WidgetButtonsPanel widgetButtonsPanelTop = new WidgetButtonsPanel();
    private WidgetButtonsPanel widgetButtonsPanelBottom = new WidgetButtonsPanel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String search;
    private String searchForNextT;
    private String searchForNextB;
    private DisplayOptions displayOptions;
    private JXTaskPane tpTop;
    private JXTaskPane tpBottom;
    private final List<String> listOfCharactersToEscape = Arrays.asList("\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":");
    private JScrollPane jScrollPane1;
    private JPanel pContents;

    public OverviewPanel() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.widgetSettingsPanelBottom.getCbFields().addItem("where.hostname");
        this.widgetSettingsPanelTop.getCbFields().addItem("what.text");
        this.widgetSettingsPanelBottom.getCbFields().setSelectedItem("where.hostname");
        this.widgetSettingsPanelTop.getCbFields().setSelectedItem("what.text");
        this.byPriorityPanel = new ByPriorityPanel();
        this.byFieldPanelTop = new ByFieldPanel();
        this.byFieldPanelBottom = new ByFieldPanel();
        this.widgets.add(this.byPriorityPanel);
        this.widgets.add(this.byFieldPanelTop);
        this.widgets.add(this.byFieldPanelBottom);
        JXTaskPaneContainer tpcTop = new JXTaskPaneContainer();
        JXTaskPaneContainer tpcBottom = new JXTaskPaneContainer();
        JPanel panelTop = new JPanel();
        panelTop.setLayout(new BorderLayout());
        panelTop.add((Component)tpcTop, "North");
        JPanel panelOther = new JPanel();
        panelOther.setLayout(new BoxLayout(panelOther, 3));
        panelOther.add((Component)tpcTop);
        panelOther.add((Component)tpcBottom);
        this.pContents.setLayout(new BorderLayout());
        this.pContents.add((Component)panelTop, "North");
        this.pContents.add((Component)panelOther, "Center");
        JXTaskPane tp1 = new JXTaskPane();
        tp1.setTitle(this.byPriority);
        tp1.add((Component)this.byPriorityPanel);
        tpcTop.add((Component)tp1);
        this.tpTop = new JXTaskPane();
        this.setTopTaskPaneTitle();
        this.tpTop.add((Component)this.widgetSettingsPanelTop);
        this.tpTop.add((Component)this.byFieldPanelTop);
        this.tpTop.add((Component)this.widgetButtonsPanelTop);
        tpcTop.add((Component)this.tpTop);
        this.tpBottom = new JXTaskPane();
        this.setBottomTaskPaneTitle();
        this.tpBottom.add((Component)this.widgetSettingsPanelBottom);
        this.tpBottom.add((Component)this.byFieldPanelBottom);
        this.tpBottom.add((Component)this.widgetButtonsPanelBottom);
        tpcBottom.add((Component)this.tpBottom);
        this.widgetSettingsPanelTop.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                this.searchForNextT = this.search;
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setTopTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelTop.getSelectedField()).setSort(this.widgetSettingsPanelTop.getSort()).setNoSources(this.widgetSettingsPanelTop.getNoSources()).setIsClickedNext(false), String.format("%s ( %s )", this.drawingWidget, this.tpTop.getTitle()), this.byFieldPanelTop, this.displayOptions));
                buttonExecutor.shutdown();
            }
        });
        this.widgetSettingsPanelBottom.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                this.searchForNextB = this.search;
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setBottomTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelBottom.getSelectedField()).setSort(this.widgetSettingsPanelBottom.getSort()).setNoSources(this.widgetSettingsPanelBottom.getNoSources()).setIsClickedNext(false), String.format(" %s ( %s )", this.drawingWidget, this.tpBottom.getTitle()), this.byFieldPanelBottom, this.displayOptions));
                buttonExecutor.shutdown();
            }
        });
        this.widgetButtonsPanelTop.getbFilterOut().addActionListener(e -> {
            FilterOutParameters parameters = new FilterOutParameters(this.byFieldPanelTop.getEventsListByField(), this.widgetSettingsPanelTop.getSelectedField());
            if (!this.byFieldPanelTop.getEventsListByField().isEmpty()) {
                this.propertyChangeSupport.firePropertyChange(FILTER_OUT_QUERY, null, parameters);
            }
        });
        this.widgetButtonsPanelBottom.getbFilterOut().addActionListener(e -> {
            FilterOutParameters parameters = new FilterOutParameters(this.byFieldPanelBottom.getEventsListByField(), this.widgetSettingsPanelBottom.getSelectedField());
            if (!this.byFieldPanelBottom.getEventsListByField().isEmpty()) {
                this.propertyChangeSupport.firePropertyChange(FILTER_OUT_QUERY, null, parameters);
            }
        });
        this.widgetButtonsPanelTop.getbExportExcel().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelTop.getCountedEventListByField();
            this.exportToExcel(this.widgetSettingsPanelTop, countedEventListByField, Orientation.T);
        });
        this.widgetButtonsPanelBottom.getbExportExcel().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelBottom.getCountedEventListByField();
            this.exportToExcel(this.widgetSettingsPanelBottom, countedEventListByField, Orientation.B);
        });
        this.widgetButtonsPanelTop.getbExportCSV().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelTop.getCountedEventListByField();
            this.exportToCSV(this.widgetSettingsPanelTop, countedEventListByField, Orientation.T);
        });
        this.widgetButtonsPanelBottom.getbExportCSV().addActionListener(e -> {
            LinkedHashMap<String, Long> countedEventListByField = this.byFieldPanelBottom.getCountedEventListByField();
            this.exportToCSV(this.widgetSettingsPanelBottom, countedEventListByField, Orientation.B);
        });
        this.widgetButtonsPanelTop.getbNext().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> eventsListByField = OverviewPanel.this.byFieldPanelTop.getEventsListByField();
                String selectedField = OverviewPanel.this.widgetSettingsPanelTop.getSelectedField();
                if (OverviewPanel.this.displayOptions != null && !eventsListByField.isEmpty()) {
                    StringBuilder query = new StringBuilder();
                    query.append(OverviewPanel.this.appendFilterOutQuery(OverviewPanel.this.searchForNextT, eventsListByField, selectedField));
                    OverviewPanel.this.searchForNextT = query.toString();
                    ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                    OverviewPanel.this.setTopTaskPaneTitle();
                    buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(OverviewPanel.this.searchForNextT, OverviewPanel.this.displayOptions).setField(OverviewPanel.this.widgetSettingsPanelTop.getSelectedField()).setSort(OverviewPanel.this.widgetSettingsPanelTop.getSort()).setNoSources(OverviewPanel.this.widgetSettingsPanelTop.getNoSources()).setIsClickedNext(true), String.format(" %s ( %s )", OverviewPanel.this.drawingWidget, OverviewPanel.this.tpTop.getTitle()), OverviewPanel.this.byFieldPanelTop, OverviewPanel.this.displayOptions));
                    buttonExecutor.shutdown();
                }
            }
        });
        this.widgetButtonsPanelBottom.getbNext().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> eventsListByField = OverviewPanel.this.byFieldPanelBottom.getEventsListByField();
                String selectedField = OverviewPanel.this.widgetSettingsPanelBottom.getSelectedField();
                if (OverviewPanel.this.displayOptions != null && !eventsListByField.isEmpty()) {
                    StringBuilder query = new StringBuilder();
                    query.append(OverviewPanel.this.appendFilterOutQuery(OverviewPanel.this.searchForNextB, eventsListByField, selectedField));
                    OverviewPanel.this.searchForNextB = query.toString();
                    ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                    OverviewPanel.this.setBottomTaskPaneTitle();
                    buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(OverviewPanel.this.searchForNextB, OverviewPanel.this.displayOptions).setField(OverviewPanel.this.widgetSettingsPanelBottom.getSelectedField()).setSort(OverviewPanel.this.widgetSettingsPanelBottom.getSort()).setNoSources(OverviewPanel.this.widgetSettingsPanelBottom.getNoSources()).setIsClickedNext(true), String.format(" %s ( %s )", OverviewPanel.this.drawingWidget, OverviewPanel.this.tpBottom.getTitle()), OverviewPanel.this.byFieldPanelBottom, OverviewPanel.this.displayOptions));
                    buttonExecutor.shutdown();
                }
            }
        });
    }

    public void setMappingsInWidgetSettigsPanels(Set<String> fields) {
        if (!fields.isEmpty()) {
            String sfLeft = this.widgetSettingsPanelTop.getSelectedField();
            String sfRight = this.widgetSettingsPanelBottom.getSelectedField();
            this.widgetSettingsPanelTop.getCbFields().removeAllItems();
            this.widgetSettingsPanelBottom.getCbFields().removeAllItems();
            fields.forEach(f -> {
                this.widgetSettingsPanelTop.getCbFields().addItem((String)f);
                this.widgetSettingsPanelBottom.getCbFields().addItem((String)f);
            });
            this.widgetSettingsPanelTop.getCbFields().setSelectedItem(sfLeft);
            this.widgetSettingsPanelBottom.getCbFields().setSelectedItem(sfRight);
        }
    }

    private void setBottomTaskPaneTitle() {
        this.tpBottom.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelBottom.getSortText(), this.widgetSettingsPanelBottom.getNoSources(), this.widgetSettingsPanelBottom.getSelectedField()));
    }

    private void setTopTaskPaneTitle() {
        this.tpTop.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelTop.getSortText(), this.widgetSettingsPanelTop.getNoSources(), this.widgetSettingsPanelTop.getSelectedField()));
    }

    public ByPriorityPanel getByPriorityPanel() {
        return this.byPriorityPanel;
    }

    private String escapeSpecialCharacters(String text) {
        for (String escape : this.listOfCharactersToEscape) {
            text = text.replace(escape, "\\" + escape);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(text).append("\"");
        text = sb.toString();
        return text;
    }

    private String appendFilterOutQuery(String actualQuery, List<String> values, String field) {
        int i;
        StringBuilder sb = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        String[] split = field.split("\\.");
        Pattern pattern = Pattern.compile(split[0] + "\\." + split[1] + ":\\(");
        Matcher matcher = pattern.matcher(actualQuery);
        while (matcher.find()) {
            startIndex = matcher.end();
        }
        if (startIndex != -1) {
            for (i = startIndex; i < actualQuery.length(); ++i) {
                if (actualQuery.charAt(i) != ')') continue;
                endIndex = i;
            }
        }
        if (endIndex != -1) {
            sb.append(actualQuery.substring(0, endIndex));
            sb.append(", ");
            for (i = 0; i < values.size(); ++i) {
                String value = this.escapeSpecialCharacters(values.get(i));
                sb.append(value);
                if (i == values.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(actualQuery.substring(endIndex));
        } else {
            sb.append(actualQuery);
            sb.append(" AND ");
            sb.append(this.makeFilterOutQuery(values, field));
        }
        return sb.toString();
    }

    private String makeFilterOutQuery(List<String> values, String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ");
        sb.append(field);
        sb.append(":(");
        for (int i = 0; i < values.size(); ++i) {
            String value = this.escapeSpecialCharacters(values.get(i));
            sb.append(value);
            if (i == values.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void update(String search, DisplayOptions displayOptions) {
        this.search = search;
        this.searchForNextT = search;
        this.searchForNextB = search;
        this.displayOptions = displayOptions;
        String progresText = "%s ( %s )";
        this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        if (this.executor.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        } else {
            this.executor.shutdownNow();
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        }
        for (Widget widget : this.widgets) {
            widget.setQueuePanel();
            if (widget instanceof ByPriorityPanel) {
                this.executor.execute(new WidgetUpdateWorker(new ByPriorityPanel.UpdateParams(search, displayOptions), String.format(progresText, this.drawingWidget, this.byPriority), widget, displayOptions));
                continue;
            }
            if (!(widget instanceof ByFieldPanel)) continue;
            if (widget.equals(this.byFieldPanelTop)) {
                this.setTopTaskPaneTitle();
                this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelTop.getSelectedField()).setSort(this.widgetSettingsPanelTop.getSort()).setNoSources(this.widgetSettingsPanelTop.getNoSources()), String.format(progresText, this.drawingWidget, this.tpTop.getTitle()), widget, displayOptions));
                continue;
            }
            if (!widget.equals(this.byFieldPanelBottom)) continue;
            this.setBottomTaskPaneTitle();
            this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelBottom.getSelectedField()).setSort(this.widgetSettingsPanelBottom.getSort()).setNoSources(this.widgetSettingsPanelBottom.getNoSources()), String.format(progresText, this.drawingWidget, this.tpBottom.getTitle()), widget, displayOptions));
        }
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToExcel(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events, Orientation orientation) {
        if (!events.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName(orientation, "xlsx"));
                XSSFWorkbook workbook = this.makeWorkbook(widgetSettingsPanel, events);
                if (workbook != null) {
                    try {
                        FileOutputStream fileWriter = new FileOutputStream(file);
                        workbook.write((OutputStream)fileWriter);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Widget.successfulExport.message"), 1));
                    }
                }
            }
        }
    }

    private XSSFWorkbook makeWorkbook(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(widgetSettingsPanel.getSelectedField());
        XSSFRow headerRow = sheet.createRow(0);
        Cell headerCell = headerRow.createCell(0);
        headerCell.setCellValue(widgetSettingsPanel.getSelectedField());
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("Count");
        Set<Map.Entry<String, Long>> entrySet = events.entrySet();
        Iterator<Map.Entry<String, Long>> it = entrySet.iterator();
        int rowCount = 1;
        while (it.hasNext()) {
            Map.Entry<String, Long> next = it.next();
            int columnCount = 0;
            XSSFRow row = sheet.createRow(rowCount++);
            Cell cell = row.createCell(columnCount++);
            cell.setCellValue(next.getKey());
            cell = row.createCell(columnCount);
            cell.setCellValue(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToCSV(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events, Orientation orientation) {
        if (!events.isEmpty()) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setDialogTitle("Export fields");
            saveDialog.setDialogType(1);
            saveDialog.setFileSelectionMode(1);
            int actionDialog = saveDialog.showSaveDialog(this);
            if (actionDialog == 0) {
                File file = new File(saveDialog.getSelectedFile().getAbsolutePath(), this.generateFileName(orientation, "csv"));
                StringBuilder sb = this.buildStringForCSVFile(widgetSettingsPanel, events);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.write(sb.toString());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OverviewPanel.class, (String)"Widget.successfulExport.message"), 1));
                }
            }
        }
    }

    private StringBuilder buildStringForCSVFile(WidgetSettingsPanel widgetSettingsPanel, LinkedHashMap<String, Long> events) {
        String separator = ";";
        StringBuilder sb = new StringBuilder();
        sb.append(widgetSettingsPanel.getSelectedField());
        sb.append(separator);
        sb.append("Count");
        sb.append(System.getProperty("line.separator"));
        Set<Map.Entry<String, Long>> entrySet = events.entrySet();
        for (Map.Entry<String, Long> next : entrySet) {
            sb.append((Object)next.getKey());
            sb.append(separator);
            sb.append(next.getValue() != null ? String.format("%,d", next.getValue()) : "");
            sb.append(System.getProperty("line.separator"));
        }
        return sb;
    }

    private String generateFileName(Orientation orientation, String fileExtension) {
        DateTime startDate = new DateTime(this.displayOptions.getTimeStart());
        DateTime finishDate = new DateTime(this.displayOptions.getTimeFinish());
        DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
        String title = orientation == Orientation.T ? this.tpTop.getTitle() : this.tpBottom.getTitle();
        title = title.replaceAll("\\s+", "").toLowerCase();
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append("_").append(startDate.toString(dtf));
        sb.append(finishDate.toString(dtf));
        sb.append(String.valueOf(System.currentTimeMillis()));
        sb.append(".").append(fileExtension);
        return sb.toString();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pContents = new JPanel();
        this.pContents.setLayout(new GridLayout(1, 2));
        this.jScrollPane1.setViewportView(this.pContents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 711, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 441, Short.MAX_VALUE).addContainerGap()));
    }

    class FilterOutParameters {
        private List<String> events;
        private String field;

        public FilterOutParameters(List<String> events, String field) {
            this.events = events;
            this.field = field;
        }

        public List<String> getEvents() {
            return this.events;
        }

        public String getField() {
            return this.field;
        }
    }

    static enum Orientation {
        B,
        T;

    }
}

