/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.AreaUtils;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class LodControl
extends AbstractControl
implements Cloneable,
JmeCloneable {
    private float trisPerPixel = 1.0f;
    private float distTolerance = 1.0f;
    private float lastDistance = 0.0f;
    private int lastLevel = 0;
    private int numLevels;
    private int[] numTris;

    public float getDistTolerance() {
        return this.distTolerance;
    }

    public void setDistTolerance(float distTolerance) {
        this.distTolerance = distTolerance;
    }

    public float getTrisPerPixel() {
        return this.trisPerPixel;
    }

    public void setTrisPerPixel(float trisPerPixel) {
        this.trisPerPixel = trisPerPixel;
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (spatial != null && !(spatial instanceof Geometry)) {
            throw new IllegalArgumentException("LodControl can only be attached to Geometry!");
        }
        super.setSpatial(spatial);
        if (spatial != null) {
            Geometry geom = (Geometry)spatial;
            Mesh mesh = geom.getMesh();
            this.numLevels = mesh.getNumLodLevels();
            this.numTris = new int[this.numLevels];
            for (int i = this.numLevels - 1; i >= 0; --i) {
                this.numTris[i] = mesh.getTriangleCount(i);
            }
        } else {
            this.numLevels = 0;
            this.numTris = null;
        }
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        LodControl clone = (LodControl)super.cloneForSpatial(spatial);
        clone.lastDistance = 0.0f;
        clone.lastLevel = 0;
        clone.numTris = this.numTris != null ? (int[])this.numTris.clone() : null;
        return clone;
    }

    @Override
    public Object jmeClone() {
        LodControl clone = (LodControl)super.jmeClone();
        clone.lastDistance = 0.0f;
        clone.lastLevel = 0;
        clone.numTris = this.numTris != null ? (int[])this.numTris.clone() : null;
        return clone;
    }

    @Override
    protected void controlUpdate(float tpf) {
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
        int level;
        BoundingVolume bv = this.spatial.getWorldBound();
        Camera cam = vp.getCamera();
        float atanNH = FastMath.atan(cam.getFrustumNear() * cam.getFrustumTop());
        float ratio = (float)Math.PI / (8.0f * atanNH);
        float newDistance = bv.distanceTo(vp.getCamera().getLocation()) / ratio;
        if (Math.abs(newDistance - this.lastDistance) <= this.distTolerance) {
            level = this.lastLevel;
        } else if (this.lastDistance > newDistance && this.lastLevel == 0) {
            level = this.lastLevel;
        } else if (this.lastDistance < newDistance && this.lastLevel == this.numLevels - 1) {
            level = this.lastLevel;
        } else {
            this.lastDistance = newDistance;
            float area = AreaUtils.calcScreenArea(bv, this.lastDistance, (float)cam.getWidth());
            float trisToDraw = area * this.trisPerPixel;
            level = this.numLevels - 1;
            int i = this.numLevels;
            while (--i >= 0 && !(trisToDraw - (float)this.numTris[i] < 0.0f)) {
                level = i;
            }
            this.lastLevel = level;
        }
        this.spatial.setLodLevel(level);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.trisPerPixel, "trisPerPixel", 1.0f);
        oc.write(this.distTolerance, "distTolerance", 1.0f);
        oc.write(this.numLevels, "numLevels", 0);
        oc.write(this.numTris, "numTris", (int[])null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.trisPerPixel = ic.readFloat("trisPerPixel", 1.0f);
        this.distTolerance = ic.readFloat("distTolerance", 1.0f);
        this.numLevels = ic.readInt("numLevels", 0);
        this.numTris = ic.readIntArray("numTris", null);
    }
}

