/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.actions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.actions.BreakAction;
import rs.co.ast.aspen.core.module.visengine.actions.ChangeNodeIdAction;
import rs.co.ast.aspen.core.module.visengine.actions.ConnectNodeAction;
import rs.co.ast.aspen.core.module.visengine.actions.ContinueAction;
import rs.co.ast.aspen.core.module.visengine.actions.HudLabelAction;
import rs.co.ast.aspen.core.module.visengine.actions.NoMatchAction;
import rs.co.ast.aspen.core.module.visengine.actions.PutAttributesAction;
import rs.co.ast.aspen.core.module.visengine.actions.RootNodeAction;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.rs.Check;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;
import rs.co.ast.aspen.core.module.visengine.scripting.ExpressionEvaluator;

public abstract class Action {
    public static Action actionFromMap(Map map, Ruleset rs) {
        if (map.size() != 1) {
            throw new IllegalArgumentException("invalid action description: " + map.toString());
        }
        Map.Entry entry = (Map.Entry)map.entrySet().toArray()[0];
        String action = (String)entry.getKey();
        Map params = (Map)entry.getValue();
        switch (action) {
            case "break": {
                return new BreakAction();
            }
            case "continue": {
                return new ContinueAction();
            }
            case "root_node": {
                return RootNodeAction.fromMap(params, rs);
            }
            case "connect_node": {
                return ConnectNodeAction.fromMap(params, rs);
            }
            case "put_attributes": {
                return PutAttributesAction.fromMap(params, rs);
            }
            case "hud_label": {
                return HudLabelAction.fromMap(params, rs);
            }
            case "no_match": {
                return new NoMatchAction();
            }
            case "change_node_id": {
                return ChangeNodeIdAction.fromMap(params, rs);
            }
        }
        throw new IllegalArgumentException("unknown action: " + action);
    }

    public abstract Check.Status execute(Graph var1, SecurityEvent var2, Node var3) throws ScriptException;

    protected Map<String, String> evaluateValues(Map<String, String> attrs, SecurityEvent event, Node node) throws ScriptException {
        return this.evaluateValues(attrs, event, node, null);
    }

    protected Map<String, String> evaluateValues(Map<String, String> attrs, SecurityEvent event, Node node, Graph graph) throws ScriptException {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                String curAttrVal = node != null ? node.get(entry.getKey()) : null;
                String value = String.valueOf(new ExpressionEvaluator(graph).eval(entry.getValue(), event, node, curAttrVal));
                ret.put(entry.getKey(), value);
            }
        }
        return ret;
    }

    protected Map<String, String> keyAttributes(Map<String, String> attrs) {
        HashMap<String, String> ret = new HashMap<String, String>();
        attrs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("*")).forEach(e -> ret.put((String)e.getKey(), (String)e.getValue()));
        return ret;
    }

    protected Map<String, String> otherAttributes(Map<String, String> attrs) {
        HashMap<String, String> ret = new HashMap<String, String>();
        attrs.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("*")).forEach(e -> ret.put((String)e.getKey(), (String)e.getValue()));
        return ret;
    }
}

