/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.KernelCompilationException;
import com.jme3.opencl.OpenCLException;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglContext;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglKernel;
import com.jme3.opencl.lwjgl.Utils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLProgram;

public class LwjglProgram
extends Program {
    private static final Logger LOG = Logger.getLogger(LwjglProgram.class.getName());
    private final CLProgram program;
    private final LwjglContext context;

    public LwjglProgram(CLProgram program, LwjglContext context) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(program));
        this.program = program;
        this.context = context;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public void build(String args, Device ... devices) throws KernelCompilationException {
        int ret;
        PointerBuffer deviceList = null;
        if (devices != null) {
            deviceList = PointerBuffer.allocateDirect((int)devices.length);
            deviceList.rewind();
            for (Device d : devices) {
                deviceList.put(((LwjglDevice)d).device.getPointer());
            }
            deviceList.flip();
        }
        if ((ret = CL10.clBuildProgram((CLProgram)this.program, (PointerBuffer)deviceList, (CharSequence)args, null)) != 0) {
            String log = this.Log();
            LOG.log(Level.WARNING, "Unable to compile program:\n{0}", log);
            if (ret == -11) {
                throw new KernelCompilationException("Failed to build program", ret, log);
            }
            Utils.checkError(ret, "clBuildProgram");
        } else {
            LOG.log(Level.INFO, "Program compiled:\n{0}", this.Log());
        }
    }

    private String Log() {
        StringBuilder str = new StringBuilder();
        for (LwjglDevice device : this.context.getDevices()) {
            CLDevice d = device.getDevice();
            str.append(device.getName()).append(":\n");
            str.append(this.program.getBuildInfoString(d, 4483));
            str.append('\n');
        }
        return str.toString();
    }

    public Kernel createKernel(String name) {
        CLKernel kernel = CL10.clCreateKernel((CLProgram)this.program, (CharSequence)name, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateKernel");
        return new LwjglKernel(kernel);
    }

    public Kernel[] createAllKernels() {
        CLKernel[] kernels = this.program.createKernelsInProgram();
        Kernel[] kx = new Kernel[kernels.length];
        for (int i = 0; i < kernels.length; ++i) {
            kx[i] = new LwjglKernel(kernels[i]);
        }
        return kx;
    }

    public ByteBuffer getBinary(Device device) {
        ByteBuffer[] binaries = this.program.getInfoBinaries((ByteBuffer[])null);
        CLDevice[] devices = this.program.getInfoDevices();
        assert (binaries.length == devices.length);
        for (int i = 0; i < devices.length; ++i) {
            if (((LwjglDevice)device).device != devices[i]) continue;
            return binaries[i];
        }
        throw new OpenCLException("Program was not built against the specified device " + device);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLProgram program;

        private ReleaserImpl(CLProgram program) {
            this.program = program;
        }

        public void release() {
        }
    }
}

