/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.gui.module.securityevents.SavedQueryDataListCellRenderer;
import rs.co.ast.aspen.gui.module.securityevents.SavedQueryDataListModel;

public class SavedQueryDataDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(SavedQueryDataDialog.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private SavedQueryDataListModel model;
    private SavedQueryData qb;
    private JScrollPane jScrollPane1;
    private JList lQueryBookmarks;
    private JMenuItem mDelete;
    private JPopupMenu pMPopUp;

    public SavedQueryDataDialog() {
        this.setTitle(NbBundle.getMessage(SavedQueryDataDialog.class, (String)"QueryBookmarksDialog.title"));
        this.initComponents();
        this.model = new SavedQueryDataListModel();
        this.lQueryBookmarks.setModel(this.model);
        this.lQueryBookmarks.setSelectionMode(0);
        this.lQueryBookmarks.setCellRenderer(new SavedQueryDataListCellRenderer());
        this.lQueryBookmarks.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    SavedQueryDataDialog.this.lQueryBookmarks.setSelectedIndex(SavedQueryDataDialog.this.lQueryBookmarks.locationToIndex(e.getPoint()));
                    SavedQueryDataDialog.this.pMPopUp.show(e.getComponent(), e.getX(), e.getY());
                }
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    SavedQueryDataDialog.this.qb = (SavedQueryData)SavedQueryDataDialog.this.lQueryBookmarks.getSelectedValue();
                    SavedQueryDataDialog.this.setVisible(false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void setData(List<SavedQueryData> list) {
        this.model.setData(list);
    }

    public SavedQueryData getSelectedQueryBookmark() {
        return this.qb;
    }

    private void initComponents() {
        this.pMPopUp = new JPopupMenu();
        this.mDelete = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.lQueryBookmarks = new JList();
        Mnemonics.setLocalizedText((AbstractButton)this.mDelete, (String)NbBundle.getMessage(SavedQueryDataDialog.class, (String)"SavedQueryDataDialog.mDelete.text"));
        this.mDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavedQueryDataDialog.this.mDeleteActionPerformed(evt);
            }
        });
        this.pMPopUp.add(this.mDelete);
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setViewportView(this.lQueryBookmarks);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void mDeleteActionPerformed(ActionEvent evt) {
        try {
            this.qb = (SavedQueryData)this.lQueryBookmarks.getSelectedValue();
            int selectedIndex = this.lQueryBookmarks.getSelectedIndex();
            this.apiService.deleteSavedQuery(this.qb.getId());
            this.model.removeElementAt(selectedIndex);
            this.lQueryBookmarks.repaint();
            this.qb = null;
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

