/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.widget.Widget;

public final class ContiguousSelectEvent {
    private final Widget previouslyChoosenWidget;
    private final Point previouslyChoosenLocalLocation;
    private final Widget choosenWidget;
    private final Point choosenLocalLocation;
    private final SelectionType selectionType;

    private ContiguousSelectEvent(Widget previouslyChoosenWidget, Point previouslyChoosenLocalLocation, Widget choosenWidget, Point choosenLocalLocation, SelectionType selectionType) {
        this.previouslyChoosenWidget = previouslyChoosenWidget;
        this.previouslyChoosenLocalLocation = previouslyChoosenLocalLocation;
        this.choosenWidget = choosenWidget;
        this.choosenLocalLocation = choosenLocalLocation;
        this.selectionType = selectionType;
    }

    public Widget getPreviouslyChoosenWidget() {
        return this.previouslyChoosenWidget;
    }

    public Point getPreviouslyChoosenLocalLocation() {
        return this.previouslyChoosenLocalLocation != null ? new Point(this.previouslyChoosenLocalLocation) : null;
    }

    public Widget getChoosenWidget() {
        return this.choosenWidget;
    }

    public Point getChoosenLocalLocation() {
        return this.choosenLocalLocation != null ? new Point(this.choosenLocalLocation) : null;
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public static ContiguousSelectEvent create(Widget previousWidget, Point previousLocalLocation, Widget choosenWidget, Point choosenLocalLocation, SelectionType selectionType) {
        assert (selectionType != null);
        return new ContiguousSelectEvent(previousWidget, previousLocalLocation, choosenWidget, choosenLocalLocation, selectionType);
    }

    public static enum SelectionType {
        REPLACE_NON_CONTIGUOUS,
        REPLACE_CONTIGUOUS,
        ADDITIVE_NON_CONTIGUOUS,
        ADDITIVE_CONTIGUOUS;

    }
}

