/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.RequestProcessor;

public class DnsUtils {
    private static final Logger LOG = Logger.getLogger(DnsUtils.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("DNSBackgroundResolvers", 5);

    public static InetAddress dnsResolveWithTimeout(String hostnameToResolve, int timeoutMs) {
        DnsTimeoutTask lookupTask = new DnsTimeoutTask(hostnameToResolve);
        RequestProcessor.Task create = RP.post((Runnable)lookupTask);
        try {
            if (timeoutMs == 0) {
                create.waitFinished();
            } else {
                create.waitFinished((long)timeoutMs);
            }
            return lookupTask.getIp();
        }
        catch (InterruptedException ex) {
            LOG.log(Level.INFO, "Timeout when waiting for DNS response. (attempting to resolve {0})", hostnameToResolve);
            return null;
        }
    }

    private static class DnsTimeoutTask
    implements Runnable {
        private final String host;
        private InetAddress ip = null;

        public DnsTimeoutTask(String host) {
            this.host = host;
        }

        @Override
        public void run() {
            try {
                this.ip = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException ex) {
                LOG.log(Level.FINEST, "DNS: could not resolve \"{0}\". Unknown host", new Object[]{ex.getMessage()});
            }
        }

        public InetAddress getIp() {
            return this.ip;
        }
    }
}

