/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.savedscript;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.SavedScript;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.CentralizedApiScriptManagerTopComponent;

@TopComponent.Description(preferredID="ApiSearchResultsTopComponent", iconBase="magnifier.png", persistenceType=2)
public final class SearchResultsTopComponent
extends TopComponent {
    private List<SavedScript> scripts = new ArrayList<SavedScript>();
    private static final String CONST_KEY = "scrypt.type.";
    private String searchString;
    private final CentralizedApiScriptManagerTopComponent scriptEditor = (CentralizedApiScriptManagerTopComponent)WindowManager.getDefault().findTopComponent("CentralizedApiScriptManagerTopComponent");
    private JScrollPane jScrollPane1;
    private JTree trResults;

    public SearchResultsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SearchResultsTopComponent.class, (String)"CTL_SearchResultsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SearchResultsTopComponent.class, (String)"HINT_SearchResultsTopComponent"));
        this.trResults.setCellRenderer(new ScriptTreeCellRenderer());
    }

    private DefaultMutableTreeNode find(DefaultMutableTreeNode root, String s) {
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.toString().equalsIgnoreCase(s)) continue;
            return node;
        }
        return null;
    }

    public void setSearchStringAndScripts(String searchString, List<SavedScript> scripts) {
        this.scripts = scripts;
        this.searchString = searchString;
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.trResults = new JTree();
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.trResults.setModel(new DefaultTreeModel(treeNode1));
        this.trResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchResultsTopComponent.this.trResultsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.trResults);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 479, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE));
    }

    private void trResultsMouseClicked(MouseEvent evt) {
        TreePath pathForLocation;
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && (pathForLocation = this.trResults.getPathForLocation(evt.getX(), evt.getY())) != null) {
            DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)pathForLocation.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)lastPathComponent.getParent();
            if (lastPathComponent.getChildCount() == 0 && !lastPathComponent.isRoot()) {
                if (!this.scriptEditor.isOpened()) {
                    this.scriptEditor.open();
                    this.scriptEditor.requestActive();
                }
                this.scriptEditor.selectAndSearchScript(parent.toString(), lastPathComponent.toString(), this.searchString);
            }
        }
    }

    public void componentOpened() {
        if (this.scripts.isEmpty()) {
            this.trResults.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(NbBundle.getMessage(SearchResultsTopComponent.class, (String)"SearchResultsTopComponent.noMatchingFiles"))));
        } else {
            this.trResults.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(String.format(NbBundle.getMessage(SearchResultsTopComponent.class, (String)"SearchResultsTopComponent.foundMatchesOf"), this.searchString, this.scripts.size()))));
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.trResults.getModel().getRoot();
            TreeSet scriptTypes = new TreeSet();
            this.scripts.forEach(s -> scriptTypes.add(s.getType()));
            scriptTypes.forEach(s -> {
                String key = CONST_KEY + s.value();
                root.add(new DefaultMutableTreeNode(NbBundle.getMessage(SearchResultsTopComponent.class, (String)key)));
            });
            this.scripts.forEach(s -> {
                String type = NbBundle.getMessage(SearchResultsTopComponent.class, (String)(CONST_KEY + s.getType().value()));
                DefaultMutableTreeNode typeNode = this.find(root, type);
                typeNode.add(new DefaultMutableTreeNode(s.getName(), s.isEnabled()));
            });
            this.expandAll(this.trResults, new TreePath(root));
        }
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public class ScriptTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (!node.getAllowsChildren()) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }
}

