/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.account;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractListModel;
import rs.co.ast.aspen.api.service.ApiRole;

public class RolesListModel
extends AbstractListModel {
    private final EnumSet<ApiRole> data = EnumSet.noneOf(ApiRole.class);

    public void addRole(ApiRole role) {
        if (role != null) {
            this.data.add(role);
            this.fireContentsChanged(this, 0, this.data.size());
        }
    }

    public void addRoles(Collection<ApiRole> roles) {
        if (roles != null && !roles.isEmpty()) {
            this.data.addAll(roles);
            this.fireContentsChanged(this, 0, this.data.size());
        }
    }

    public void clear() {
        int l = this.data.size();
        this.data.clear();
        this.fireIntervalRemoved(this, 0, l);
    }

    @Override
    public Object getElementAt(int index) {
        return index < this.data.size() ? this.data.toArray()[index] : null;
    }

    public Collection<ApiRole> getRoles() {
        return this.data;
    }

    public void setRoles(ApiRole[] roles) {
        this.data.clear();
        if (roles.length != 0) {
            this.data.addAll(Arrays.asList(roles));
        }
        this.fireContentsChanged(this, 0, this.data.size());
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    public void removeRole(ApiRole role) {
        if (role != null) {
            this.data.remove(role);
            this.fireContentsChanged(this, 0, this.data.size());
        }
    }

    public void removeRoles(Collection<ApiRole> roles) {
        if (roles != null && !roles.isEmpty()) {
            this.data.removeAll(roles);
            this.fireContentsChanged(this, 0, this.data.size());
        }
    }
}

