/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.api.service;

import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiServiceExceptionType;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.AspenApiService;
import rs.co.ast.aspen.api.service.MethodImpl;

public class MethodExecutor {
    private String sid;
    private AspenApiService apiService;

    public MethodExecutor(String sid, AspenApiService apiService) {
        this.sid = sid;
        this.apiService = apiService;
    }

    public <T> T execute(MethodImpl<T> code) throws ApiServiceException_Exception {
        if (this.sid == null || this.apiService == null) {
            this.restartApp();
        }
        try {
            return code.execute(this.sid, this.apiService);
        }
        catch (ApiServiceException_Exception ex) {
            if (ex.getFaultInfo().getType() == ApiServiceExceptionType.INVALID_SESSION) {
                this.askToRestartApp();
            }
            throw ex;
        }
    }

    private void askToRestartApp() {
        NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(MethodExecutor.class, (String)"restartmsg.text"), NbBundle.getMessage(MethodExecutor.class, (String)"restartmsg.title"), 2, 0, null, null);
        Object r = DialogDisplayer.getDefault().notify(nd);
        if (r.equals(NotifyDescriptor.OK_OPTION)) {
            this.restartApp();
        }
    }

    private void restartApp() {
        LifecycleManager.getDefault().markForRestart();
        LifecycleManager.getDefault().exit();
    }
}

