/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import rs.co.ast.aspen.gui.module.prseditor.Filter;
import rs.co.ast.aspen.gui.module.prseditor.TestGroupWrapper;
import rs.co.ast.aspen.gui.module.prseditor.TestRuleSetWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestGroupNode;

public class TestRuleSetNode
extends AbstractMutableTreeTableNode {
    private TestRuleSetWrapper ruleSetWrapper;
    private List<TestGroupNode> childrens = new ArrayList<TestGroupNode>();
    private boolean success;

    public TestRuleSetNode(MutableTreeTableNode parent, TestRuleSetWrapper ruleSetWrapper, boolean success, Filter filter) {
        this.parent = parent;
        this.ruleSetWrapper = ruleSetWrapper;
        this.success = success;
        this.createChildNodes(filter);
    }

    private void createChildNodes(Filter filter) {
        for (TestGroupWrapper g : this.ruleSetWrapper.getSubGroups()) {
            TestGroupNode tgn = new TestGroupNode((MutableTreeTableNode)this, g, g.isSuccess(), filter);
            this.childrens.add(tgn);
        }
    }

    public TestRuleSetWrapper getRuleSetWrapper() {
        return this.ruleSetWrapper;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.ruleSetWrapper;
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 4;
    }

    public void setParent(MutableTreeTableNode newParent) {
        this.parent = newParent;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<TestGroupNode> getChildren() {
        return this.childrens;
    }

    public boolean addChild(TestGroupNode childNode) {
        return this.childrens.add(childNode);
    }

    public boolean checkSuccess() {
        boolean ret = true;
        for (TestGroupWrapper g : this.ruleSetWrapper.getSubGroups()) {
            if (g.isSuccess()) continue;
            ret = false;
            break;
        }
        return ret;
    }
}

