/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import rs.co.ast.aspen.api.service.ParsingRuleTestResult;
import rs.co.ast.aspen.gui.module.prseditor.Filter;
import rs.co.ast.aspen.gui.module.prseditor.TestRuleWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestGroupNode;

public class TestRuleNode
extends AbstractMutableTreeTableNode {
    private List<TestCaseNode> childrens = new ArrayList<TestCaseNode>();
    private TestRuleWrapper ruleWrapper;
    private boolean success;

    public TestRuleNode(MutableTreeTableNode parent, TestRuleWrapper ruleWrapper, boolean success, Filter filter) {
        this.parent = parent;
        this.ruleWrapper = ruleWrapper;
        this.success = success;
        this.createChildNodes(filter);
    }

    public boolean addChild(TestCaseNode childNode) {
        return this.childrens.add(childNode);
    }

    public List<TestCaseNode> getChildren() {
        return this.childrens;
    }

    public int getColumnCount() {
        return 4;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public void setParent(MutableTreeTableNode newParent) {
        this.parent = newParent;
    }

    public TestRuleWrapper getRuleWrapper() {
        return this.ruleWrapper;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.ruleWrapper;
            }
        }
        return "";
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
        TestGroupNode tg = (TestGroupNode)this.parent;
        tg.checkSuccess();
    }

    private void createChildNodes(Filter filter) {
        block5: for (ParsingRuleTestResult tr : this.ruleWrapper.getTestResult().getResults()) {
            switch (filter.getFilterType()) {
                case ALL: {
                    this.createTestCaseNode(tr);
                    continue block5;
                }
                case SUCCESSFUL: {
                    if (!tr.isSuccedeed()) continue block5;
                    this.createTestCaseNode(tr);
                    continue block5;
                }
                case FAILED: {
                    if (tr.isSuccedeed()) continue block5;
                    this.createTestCaseNode(tr);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid filter value");
        }
    }

    private void createTestCaseNode(ParsingRuleTestResult tr) {
        TestCaseNode tcn = new TestCaseNode((MutableTreeTableNode)this, tr.getTestCase(), tr, tr.isSuccedeed());
        this.childrens.add(tcn);
    }

    public void checkSuccess() {
        for (ParsingRuleTestResult tr : this.ruleWrapper.getTestResult().getResults()) {
            if (!tr.getFailedChecks().isEmpty()) {
                this.success = false;
                continue;
            }
            this.success = true;
        }
    }
}

