/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.HasId;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupsChildFactory;

public class RulesGroupNode
extends AbstractNode
implements PropertyChangeListener,
NodeListener,
HasId {
    private ParsingRulesGroupDTOWrapper group;
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);

    public RulesGroupNode(ParsingRulesGroupDTOWrapper group) {
        super(Children.LEAF, Lookups.singleton((Object)group));
        if (!group.getGroupIds().isEmpty()) {
            this.setChildren(Children.create((ChildFactory)new RulesGroupsChildFactory(group.getId()), (boolean)true));
        }
        this.setDisplayName(group.getName());
        this.setIconBaseWithExtension("folder.png");
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.group = group;
        this.group.addPropertyChangeListener((PropertyChangeListener)this);
        this.addNodeListener(this);
        this.addPropertyChangeListener(this);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return this.model.isEditMode();
    }

    public boolean canRename() {
        return this.model.isEditMode();
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void destroy() throws IOException {
        this.fireNodeDestroyed();
    }

    public Action[] getActions(boolean context) {
        if (this.model.isEditMode()) {
            return new Action[]{(Action)Utilities.actionsForPath((String)"Actions/RightClickRuleSet").get(0), (Action)Utilities.actionsForPath((String)"Actions/RightClickGroup").get(0), (Action)Utilities.actionsForPath((String)"Actions/RightClickGroup").get(1), (Action)Utilities.actionsForPath((String)"Actions/RightClickGroup").get(2), (Action)Utilities.actionsForPath((String)"Actions/EditMode").get(0)};
        }
        return new Action[]{(Action)Utilities.actionsForPath((String)"Actions/EditMode").get(0), (Action)Utilities.actionsForPath((String)"Actions/RightClickGroup").get(2)};
    }

    public ParsingRulesGroupDTOWrapper getGroup() {
        return this.group;
    }

    public String getHtmlDisplayName() {
        String name = this.group.getName();
        if (this.group.isDirty()) {
            return "<html><strong>" + name + "</strong></html>";
        }
        if (this.group.isForDelete()) {
            return "<html><strong><strike>" + name + "</strike></strong></html>";
        }
        return name;
    }

    @Override
    public String getId() {
        return this.group.getId();
    }

    public void nodeDestroyed(NodeEvent ne) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            String newValue;
            if (evt.getNewValue() instanceof String && (newValue = (String)evt.getNewValue()) != null) {
                this.setDisplayName(newValue);
                this.model.setGroupName(this.group, newValue);
            }
        } else if (evt.getPropertyName().equals("groupChanged")) {
            this.fireDisplayNameChange("", this.getDisplayName());
        }
    }

    public void updateChildren(ParsingRulesGroupDTOWrapper group) {
        this.setChildren(Children.create((ChildFactory)new RulesGroupsChildFactory(group.getId()), (boolean)true));
    }

    public void updateChildren(String groupParentId) {
        this.setChildren(Children.create((ChildFactory)new RulesGroupsChildFactory(groupParentId), (boolean)true));
    }
}

