/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ParsingRuleTestResult;
import rs.co.ast.aspen.api.service.RegressionTestResult;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.Filter;
import rs.co.ast.aspen.gui.module.prseditor.TestGroupWrapper;
import rs.co.ast.aspen.gui.module.prseditor.TestGroupingElementWrapper;
import rs.co.ast.aspen.gui.module.prseditor.TestResult;
import rs.co.ast.aspen.gui.module.prseditor.TestRuleSetWrapper;
import rs.co.ast.aspen.gui.module.prseditor.TestRuleWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseCheckNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestCaseNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestGroupNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRootNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleSetNode;

public class RegressionTestResultTreeTableModel
extends AbstractTreeTableModel {
    private Collection<ParsingRulesGroupDTOWrapper> groups = null;
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private TestRootNode rootNode = null;
    private Collection<ParsingRuleDTOWrapper> rules = null;
    private Collection<ParsingRuleSetDTOWrapper> rulesets = null;
    private TestResult testResult = new TestResult();

    public final void createNodes(Filter filter) {
        try {
            Map createRegressionTestResultsMap = this.model.createRegressionTestResultsMap();
            this.rulesets = this.model.getRuleSets();
            this.groups = this.model.getAllGroups();
            this.rules = this.model.getAllRules();
            this.testResult.reset();
            this.rootNode = new TestRootNode(this.repackData(createRegressionTestResultsMap), filter);
            this.modelSupport.fireNewRoot();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof TestRootNode) {
            return ((TestRootNode)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof TestRuleSetNode) {
            return ((TestRuleSetNode)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof TestGroupNode) {
            return ((TestGroupNode)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof TestRuleNode) {
            return ((TestRuleNode)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof TestCaseNode) {
            return ((TestCaseNode)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof TestCaseCheckNode) {
            return ((TestCaseCheckNode)((Object)parent)).getChildren().get(index);
        }
        throw new IllegalArgumentException("Invalid child index");
    }

    public int getChildCount(Object parent) {
        if (parent instanceof TestRootNode) {
            return ((TestRootNode)((Object)parent)).getChildren().size();
        }
        if (parent instanceof TestRuleSetNode) {
            return ((TestRuleSetNode)((Object)parent)).getChildren().size();
        }
        if (parent instanceof TestGroupNode) {
            return ((TestGroupNode)((Object)parent)).getChildren().size();
        }
        if (parent instanceof TestRuleNode) {
            return ((TestRuleNode)((Object)parent)).getChildren().size();
        }
        if (parent instanceof TestCaseNode) {
            return ((TestCaseNode)((Object)parent)).getChildren().size();
        }
        if (parent instanceof TestCaseCheckNode) {
            return ((TestCaseCheckNode)((Object)parent)).getChildren().size();
        }
        throw new IllegalArgumentException("Invalid parent");
    }

    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return NbBundle.getMessage(RegressionTestResultTreeTableModel.class, (String)"regressionTestResultsTableModel.col0.title");
            }
            case 1: {
                return NbBundle.getMessage(RegressionTestResultTreeTableModel.class, (String)"regressionTestResultsTableModel.col1.title");
            }
            case 2: {
                return NbBundle.getMessage(RegressionTestResultTreeTableModel.class, (String)"regressionTestResultsTableModel.col2.title");
            }
            case 3: {
                return NbBundle.getMessage(RegressionTestResultTreeTableModel.class, (String)"regressionTestResultsTableModel.col3.title");
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public int getCount() {
        return this.testResult.getSum();
    }

    public int getFailedCount() {
        return this.testResult.getFailed();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof TestRootNode) {
            return ((TestRootNode)((Object)parent)).getChildren().indexOf(child);
        }
        if (parent instanceof TestRuleSetNode) {
            return ((TestRuleSetNode)((Object)parent)).getChildren().indexOf(child);
        }
        if (parent instanceof TestGroupNode) {
            return ((TestGroupNode)((Object)parent)).getChildren().indexOf(child);
        }
        if (parent instanceof TestRuleNode) {
            return ((TestRuleNode)((Object)parent)).getChildren().indexOf(child);
        }
        if (parent instanceof TestCaseNode) {
            return ((TestCaseNode)((Object)parent)).getChildren().indexOf(child);
        }
        if (parent instanceof TestCaseCheckNode) {
            return ((TestCaseCheckNode)((Object)parent)).getChildren().indexOf(child);
        }
        throw new IllegalArgumentException("Invalid parent and/or child");
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public int getSucceededCount() {
        return this.testResult.getSucceeded();
    }

    public TreePath getTreePath(TreeTableNode node) {
        ArrayList<TreeTableNode> list = new ArrayList<TreeTableNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof TestRootNode) {
            return ((TestRootNode)((Object)node)).getValueAt(column);
        }
        if (node instanceof TestRuleSetNode) {
            return ((TestRuleSetNode)((Object)node)).getValueAt(column);
        }
        if (node instanceof TestGroupNode) {
            return ((TestGroupNode)((Object)node)).getValueAt(column);
        }
        if (node instanceof TestRuleNode) {
            return ((TestRuleNode)((Object)node)).getValueAt(column);
        }
        if (node instanceof TestCaseNode) {
            return ((TestCaseNode)((Object)node)).getValueAt(column);
        }
        if (node instanceof TestCaseCheckNode) {
            return ((TestCaseCheckNode)((Object)node)).getValueAt(column);
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void updateDisplay(Filter filter) {
        this.createNodes(filter);
    }

    private void countResults(RegressionTestResult result) {
        for (ParsingRuleTestResult tr : result.getResults()) {
            if (tr.isSuccedeed()) {
                this.testResult.setSucceeded(this.testResult.getSucceeded() + 1);
            } else {
                this.testResult.setFailed(this.testResult.getFailed() + 1);
            }
            this.testResult.setSum(this.testResult.getSum() + 1);
        }
    }

    private void recursionGroup2(List<String> ids, Map<String, TestRuleSetWrapper> trswMap, Map<String, TestGroupWrapper> tgwMap, Map<String, TestRuleWrapper> trwMap, Map<String, RegressionTestResult> createRegressionTestResultsMap) {
        for (ParsingRulesGroupDTOWrapper group : this.groups) {
            TestGroupingElementWrapper parent;
            if (ids.isEmpty()) break;
            if (!ids.contains(group.getId()) || tgwMap.containsKey(group.getId())) continue;
            TestGroupWrapper tgw = new TestGroupWrapper();
            tgw.setGroup(group);
            tgwMap.put(group.getId(), tgw);
            if (trswMap.containsKey(group.getParentId())) {
                parent = trswMap.get(group.getParentId());
                if (parent != null && ((TestRuleSetWrapper)parent).getSubGroups() != null) {
                    ((TestRuleSetWrapper)parent).getSubGroups().add(tgw);
                }
            } else {
                parent = tgwMap.get(group.getParentId());
                if (parent != null && ((TestGroupWrapper)parent).getSubGroups() != null) {
                    ((TestGroupWrapper)parent).getSubGroups().add(tgw);
                }
            }
            this.recursionGroup2(group.getGroupIds(), trswMap, tgwMap, trwMap, createRegressionTestResultsMap);
            for (ParsingRuleDTOWrapper rule : this.rules) {
                if (!group.getRuleIds().contains(rule.getId())) continue;
                for (String id : createRegressionTestResultsMap.keySet()) {
                    if (!rule.getId().equals(id)) continue;
                    TestRuleWrapper trw = new TestRuleWrapper();
                    trw.setRule(rule);
                    RegressionTestResult res = createRegressionTestResultsMap.get(rule.getId());
                    trw.setTestResult(res);
                    trwMap.put(rule.getId(), trw);
                    tgw.getTestRules().add(trw);
                    this.countResults(res);
                }
            }
        }
    }

    private Map<String, TestRuleSetWrapper> repackData(Map<String, RegressionTestResult> createRegressionTestResultsMap) {
        HashMap<String, TestRuleSetWrapper> trswMap = new HashMap<String, TestRuleSetWrapper>();
        HashMap<String, TestGroupWrapper> tgwMap = new HashMap<String, TestGroupWrapper>();
        HashMap<String, TestRuleWrapper> trwMap = new HashMap<String, TestRuleWrapper>();
        for (ParsingRuleSetDTOWrapper ruleset : this.rulesets) {
            TestRuleSetWrapper trsw = new TestRuleSetWrapper();
            trsw.setRuleset(ruleset);
            trswMap.put(ruleset.getId(), trsw);
            this.recursionGroup2(ruleset.getGroupIds(), trswMap, tgwMap, trwMap, createRegressionTestResultsMap);
        }
        return trswMap;
    }
}

