/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.PRSTreeExplorerManager;
import rs.co.ast.aspen.gui.module.prseditor.PRSTreePanel;
import rs.co.ast.aspen.gui.module.prseditor.RulesPanel;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;

@TopComponent.Description(preferredID="ParsingRulesetEditorTopComponent", iconBase="rs/co/ast/aspen/gui/module/prseditor/text_signature.png", persistenceType=0)
public final class ParsingRulesetEditorTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ParsingRulesetEditorTopComponent.class.getName());
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private PRSTreePanel prsTreePanel = new PRSTreePanel(PRSTreeExplorerManager.PRSTreePanelsIDs.MAIN);
    private ExplorerManager explorerManager = PRSTreeExplorerManager.getMainPRSTreeExplorerManager();
    private RulesPanel rulesPanel;
    private JButton bReset;
    private JButton bUpdate;
    private JSplitPane jSplitPane1;
    private JPanel pLeft;
    private JPanel pTreeParent;

    public ParsingRulesetEditorTopComponent() {
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.PRSEDITOR), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.PRSEDITOR)));
        this.initComponents();
        this.setName(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"CTL_ParsingRulesetEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"HINT_ParsingRulesetEditorTopComponent"));
        this.rulesPanel = new RulesPanel();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.prsTreePanel.getExplorerManager(), (ActionMap)this.getActionMap()), this.rulesPanel.getSelectedRuleLookup(), this.rulesPanel.getRuleDetailsPanel().getSelectedMetaRuleLookup(), this.rulesPanel.getRuleDetailsPanel().getSelectedAssignmentLookup(), this.rulesPanel.getRuleDetailsPanel().getSelectedTestCaseLookup()}));
        this.prsTreePanel.addPropertyChangeListener(this);
        this.rulesPanel.addPropertyChangeListener(this);
        this.pTreeParent.setLayout(new BoxLayout(this.pTreeParent, 1));
        this.pTreeParent.add(this.prsTreePanel);
        this.jSplitPane1.setRightComponent(this.rulesPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("ancestor")) {
            this.setHtmlDisplayName("<html><strong>" + this.getName() + "</strong></html>");
            this.rulesPanel.updateDisplay();
            this.bUpdate.setEnabled(true);
            this.bReset.setEnabled(true);
        }
    }

    private List<String> getParentIdListForGroupId(String groupId) {
        String parentId = this.model.getParentIdForGroupId(groupId);
        ArrayList<String> parents = new ArrayList<String>();
        parents.add(groupId);
        if (parentId != null) {
            parents.add(parentId);
        }
        while (this.model.getParentIdForGroupId(parentId) != null) {
            parentId = this.model.getParentIdForGroupId(parentId);
            parents.add(parentId);
        }
        Collections.reverse(parents);
        return parents;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.pLeft = new JPanel();
        this.bReset = new JButton();
        this.bUpdate = new JButton();
        this.pTreeParent = new JPanel();
        this.jSplitPane1.setDividerLocation(255);
        this.bReset.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ParsingRulesetEditorTopComponent.bReset.text"));
        this.bReset.setEnabled(false);
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParsingRulesetEditorTopComponent.this.bResetActionPerformed(evt);
            }
        });
        this.bUpdate.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdate, (String)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ParsingRulesetEditorTopComponent.bUpdate.text"));
        this.bUpdate.setEnabled(false);
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParsingRulesetEditorTopComponent.this.bUpdateActionPerformed(evt);
            }
        });
        GroupLayout pTreeParentLayout = new GroupLayout(this.pTreeParent);
        this.pTreeParent.setLayout(pTreeParentLayout);
        pTreeParentLayout.setHorizontalGroup(pTreeParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pTreeParentLayout.setVerticalGroup(pTreeParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 430, Short.MAX_VALUE));
        GroupLayout pLeftLayout = new GroupLayout(this.pLeft);
        this.pLeft.setLayout(pLeftLayout);
        pLeftLayout.setHorizontalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addComponent(this.bUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset).addContainerGap(86, Short.MAX_VALUE)).addComponent(this.pTreeParent, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        pLeftLayout.setVerticalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pLeftLayout.createSequentialGroup().addComponent(this.pTreeParent, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bReset).addComponent(this.bUpdate)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.pLeft);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 937, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        ParsingRulesGroupDTOWrapper group = (ParsingRulesGroupDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRulesGroupDTOWrapper.class);
        ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
        if (group != null && rule != null) {
            List<String> parentIdListForGroupId = this.getParentIdListForGroupId(group.getId());
            this.model.commitChanges();
            this.model.setEditMode(false);
            this.prsTreePanel.displayData(parentIdListForGroupId, rule);
            this.bUpdate.setEnabled(false);
            this.bReset.setEnabled(false);
            this.setHtmlDisplayName(null);
            this.setDisplayName(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"CTL_ParsingRulesetEditorTopComponent"));
        } else {
            LOGGER.warning(String.format("Group: %s, Rule: %s", group == null ? "null" : group.getName(), rule == null ? "null" : rule.getDescription()));
        }
    }

    private void bResetActionPerformed(ActionEvent evt) {
        ParsingRulesGroupDTOWrapper group = (ParsingRulesGroupDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRulesGroupDTOWrapper.class);
        ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
        this.model.reset();
        this.model.setEditMode(false);
        if (group != null && rule != null) {
            List<String> parentIdListForGroupId = this.getParentIdListForGroupId(group.getId());
            this.prsTreePanel.displayData(parentIdListForGroupId, rule);
        } else if (this.explorerManager != null) {
            RootNode rootNode = (RootNode)this.explorerManager.getRootContext();
            rootNode.updateChildren();
        }
        this.bUpdate.setEnabled(false);
        this.bReset.setEnabled(false);
        this.setHtmlDisplayName(null);
        this.setDisplayName(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"CTL_ParsingRulesetEditorTopComponent"));
    }

    public void componentOpened() {
        this.prsTreePanel.displayData();
    }

    public void componentClosed() {
        this.model.clearAllMaps();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
    }
}

