/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.HasId;
import rs.co.ast.aspen.gui.module.prseditor.PRSTreeExplorerManager;
import rs.co.ast.aspen.gui.module.prseditor.UpdateState;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusGroup;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusGroupService;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusRuleService;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetsChildFactory;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public class PRSTreePanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
LookupListener {
    public final PRSTreeExplorerManager.PRSTreePanelsIDs id;
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private TreeTableView treeTableView = new TreeTableView();
    private ExplorerManager explorerManager;
    private RootNode node;
    private final Lookup.Result<FocusGroup> result;
    private final FocusGroupService groupService = (FocusGroupService)Lookup.getDefault().lookup(FocusGroupService.class);
    private FocusRuleService ruleService = (FocusRuleService)Lookup.getDefault().lookup(FocusRuleService.class);
    private UpdateState state = new UpdateState();
    private transient NodeAdapter nodeListener = new NodeAdapter(){

        public void childrenAdded(NodeMemberEvent ev) {
            for (final Node n : ev.getNode().getChildren().getNodes()) {
                if (!(n instanceof HasId)) continue;
                HasId h = (HasId)n;
                if (PRSTreePanel.this.state.getIndex() >= PRSTreePanel.this.state.getExpandGroupIds().size() || !h.getId().equals(PRSTreePanel.this.state.getExpandGroupIds().get(PRSTreePanel.this.state.getIndex()))) continue;
                PRSTreePanel.this.state.getPrevNode().removeNodeListener((NodeListener)this);
                n.addNodeListener((NodeListener)this);
                if (PRSTreePanel.this.state.getIndex() == PRSTreePanel.this.state.getExpandGroupIds().size() - 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PRSTreePanel.this.explorerManager.setSelectedNodes(new Node[]{n});
                                PRSTreePanel.this.ruleService.ruleFocusChanged(PRSTreePanel.this.state.getRuleToSelect());
                                PRSTreePanel.this.state.setIndex(0);
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PRSTreePanel.this.treeTableView.expandNode(n);
                        }
                    });
                }
                PRSTreePanel.this.state.setIndex(PRSTreePanel.this.state.getIndex() + 1);
                PRSTreePanel.this.state.setPrevNode(n);
                break;
            }
        }
    };
    private List<Node> nodesToExpand = new ArrayList<Node>();
    private JScrollPane jScrollPane1;

    public PRSTreePanel(PRSTreeExplorerManager.PRSTreePanelsIDs id) {
        this.id = id;
        this.createExplorerManager();
        this.initComponents();
        this.treeTableView.setPopupAllowed(true);
        this.treeTableView.setQuickSearchAllowed(false);
        this.result = this.groupService.getLookup().lookupResult(FocusGroup.class);
        this.result.addLookupListener((LookupListener)this);
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
    }

    private Node getNodeToExpand(Node[] allNodes, String id) {
        Node retNode = null;
        for (Node n : allNodes) {
            if (n instanceof RulesGroupNode) {
                RulesGroupNode rgn = (RulesGroupNode)n;
                if (rgn.getGroup().getId().equals(id)) {
                    this.nodesToExpand.add(n);
                    retNode = n;
                    break;
                }
                retNode = this.getNodeToExpand(n.getChildren().getNodes(), id);
                if (retNode == null) continue;
                this.nodesToExpand.add(n);
                break;
            }
            retNode = this.getNodeToExpand(n.getChildren().getNodes(), id);
            if (retNode == null) continue;
            this.nodesToExpand.add(n);
            break;
        }
        return retNode;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void displayData() {
        this.displayData(null, null);
    }

    public void displayData(List<String> expand, ParsingRuleDTOWrapper rule) {
        this.node = new RootNode(Children.create((ChildFactory)new RuleSetsChildFactory(), (boolean)true));
        this.explorerManager.setRootContext((Node)this.node);
        if (expand != null) {
            this.state.setExpandGroupIds(expand);
            this.state.setRuleToSelect(rule);
            this.state.setPrevNode((Node)this.node);
            this.node.addNodeListener((NodeListener)this.nodeListener);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = this.treeTableView;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 411, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("ancestor")) {
            switch (evt.getPropertyName()) {
                case "groupAdded": 
                case "groupRemoved": 
                case "ruleChanged": 
                case "groupChanged": {
                    this.firePropertyChange("groupChanged", "", evt.getNewValue());
                    break;
                }
                case "ruleSetAdded": 
                case "ruleSetRemoved": 
                case "ruleSetChanged": {
                    this.firePropertyChange("ruleSetChanged", "", evt.getNewValue());
                }
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        Lookup.Result r = (Lookup.Result)ev.getSource();
        Collection instances = r.allInstances();
        for (Object o : instances) {
            if (!(o instanceof FocusGroup)) continue;
            final FocusGroup fg = (FocusGroup)o;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Node nodeToExpand = PRSTreePanel.this.getNodeToExpand(PRSTreePanel.this.node.getChildren().getNodes(), fg.getGroupId());
                        Collections.reverse(PRSTreePanel.this.nodesToExpand);
                        if (nodeToExpand != null) {
                            for (Node n : PRSTreePanel.this.nodesToExpand) {
                                PRSTreePanel.this.treeTableView.expandNode(n);
                            }
                            PRSTreePanel.this.explorerManager.setSelectedNodes(new Node[]{nodeToExpand});
                        }
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void createExplorerManager() {
        switch (this.id) {
            case MAIN: {
                this.explorerManager = PRSTreeExplorerManager.getMainPRSTreeExplorerManager();
                break;
            }
            case JUMPTO: {
                this.explorerManager = PRSTreeExplorerManager.getJumpToPRSTreeExplorerManager();
            }
        }
    }

    public class MyAncestorListener
    implements AncestorListener {
        private PRSTreePanel panel;

        public MyAncestorListener(PRSTreePanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            PRSTreePanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            PRSTreePanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

