/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.api.service.HostStatsGuiReport;
import rs.co.ast.aspen.gui.module.datamaps.DataMapsTopComponent;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SourceStatisticsTableModel;

public class SourceStatisticsPanel
extends JPanel {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final SourceStatisticsTableModel tableModel = new SourceStatisticsTableModel();
    private final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
    private JButton bExport;
    private JButton bRefresh;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lDelimeter;
    private JLabel lDomainCount;
    private JLabel lFinish;
    private JLabel lHostCount;
    private JXBusyLabel lLoading;
    private JLabel lQuery;
    private JLabel lStart;
    private JTable tCountOfHostNamesPerDomain;
    private JTextField tfDelimeter;
    private JTextField tfQuery;

    public SourceStatisticsPanel() {
        this.initComponents();
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
        long now = System.currentTimeMillis();
        this.dtpTimeStart.setDate(new Date(now - 28800000L));
        this.dtpTimeFinish.setDate(new Date(now));
        this.tCountOfHostNamesPerDomain.setModel(this.tableModel);
    }

    public long getStartTime() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getFinishTime() {
        return this.dtpTimeFinish.getDate().getTime();
    }

    public String getQuery() {
        return this.tfQuery.getText();
    }

    public String getDelimeter() {
        return this.tfDelimeter.getText();
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private String genFileName() {
        DateTime now = new DateTime();
        String ext = ".csv";
        return String.format("%s_%s.%s", "SourceStatistics", now.toString(this.dtf), ext);
    }

    private void initComponents() {
        this.tfQuery = new JTextField();
        this.lQuery = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.dtpTimeFinish = new JXDatePicker();
        this.lStart = new JLabel();
        this.lFinish = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lHostCount = new JLabel();
        this.lDomainCount = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tCountOfHostNamesPerDomain = new JTable();
        this.bRefresh = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bExport = new JButton();
        this.lDelimeter = new JLabel();
        this.tfDelimeter = new JTextField();
        this.tfQuery.setText(NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.tfQuery.text"));
        Mnemonics.setLocalizedText((JLabel)this.lQuery, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lQuery.text"));
        Mnemonics.setLocalizedText((JLabel)this.lStart, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lStart.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lFinish.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.lHostCount, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lHostCount.text"));
        Mnemonics.setLocalizedText((JLabel)this.lDomainCount, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lDomainCount.text"));
        this.tCountOfHostNamesPerDomain.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tCountOfHostNamesPerDomain);
        this.bRefresh.setIcon(new ImageIcon(this.getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.bRefresh.text"));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsPanel.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lHostCount).addGap(18, 18, 18).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.lDomainCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bRefresh))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.lHostCount).addComponent(this.lDomainCount).addComponent(this.bRefresh)).addComponent((Component)this.lLoading, -1, 29, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 266, Short.MAX_VALUE).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsPanel.this.bExportActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lDelimeter, (String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.lDelimeter.text"));
        this.tfDelimeter.setText(NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.tfDelimeter.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.lQuery).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfQuery, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lStart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.dtpTimeStart, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lFinish).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.dtpTimeFinish, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lDelimeter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfDelimeter, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 85, Short.MAX_VALUE).addComponent(this.bExport).addGap(24, 24, 24)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQuery, -2, -1, -2).addComponent(this.lQuery).addComponent(this.lStart).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent(this.lFinish).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.bExport).addComponent(this.lDelimeter).addComponent(this.tfDelimeter, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        SwingWorker<HostStatsGuiReport, Void> worker = new SwingWorker<HostStatsGuiReport, Void>(){

            @Override
            protected HostStatsGuiReport doInBackground() throws Exception {
                SourceStatisticsPanel.this.toggleLoading();
                try {
                    return SourceStatisticsPanel.this.apiService.hostGuiReport(SourceStatisticsPanel.this.getQuery(), SourceStatisticsPanel.this.getStartTime(), SourceStatisticsPanel.this.getFinishTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsPanel.this.toggleLoading();
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    HostStatsGuiReport hostGuiReport = (HostStatsGuiReport)this.get();
                    SourceStatisticsPanel.this.lHostCount.setText(String.valueOf(hostGuiReport.getDistinctHosts()));
                    SourceStatisticsPanel.this.lDomainCount.setText(String.valueOf(hostGuiReport.getDistinctDomains()));
                    List hostsPerDomain = hostGuiReport.getHostsPerDomain();
                    SourceStatisticsPanel.this.tableModel.update(hostsPerDomain);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    SourceStatisticsPanel.this.toggleLoading();
                }
            }
        };
        worker.execute();
    }

    private void bExportActionPerformed(ActionEvent evt) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SourceStatisticsPanel.class, (String)"SourceStatisticsPanel.export_progress.title"));
        SwingWorker<HostStatsCsvReport, Void> worker = new SwingWorker<HostStatsCsvReport, Void>(){

            @Override
            protected HostStatsCsvReport doInBackground() throws Exception {
                SourceStatisticsPanel.this.toggleLoading();
                try {
                    ph.start();
                    return SourceStatisticsPanel.this.apiService.hostCsvReport(SourceStatisticsPanel.this.getQuery(), SourceStatisticsPanel.this.getStartTime(), SourceStatisticsPanel.this.getFinishTime(), SourceStatisticsPanel.this.getDelimeter());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsPanel.this.toggleLoading();
                    ph.finish();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block18: {
                    try {
                        HostStatsCsvReport hostCsvReport = (HostStatsCsvReport)this.get();
                        String fileName = SourceStatisticsPanel.this.genFileName();
                        JFileChooser saveDialog = new JFileChooser();
                        saveDialog.setDialogTitle(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.title"));
                        saveDialog.setDialogType(1);
                        saveDialog.setSelectedFile(new File(fileName));
                        int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        if (actionDialog == 0) {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            try (FileOutputStream stream = new FileOutputStream(dfile);){
                                stream.write(hostCsvReport.getDataHandler());
                                break block18;
                            }
                        }
                        ph.finish();
                    }
                    catch (IOException | InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        SourceStatisticsPanel.this.toggleLoading();
                        ph.finish();
                    }
                }
            }
        };
        worker.execute();
    }
}

