/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.nodes;

import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.DatamapsDrawingHelper;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapKeyNode;

public class DataMapKeyChildFactory
extends ChildFactory<DataMapKey> {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private String mapName;
    private DatamapsDrawingHelper dmdh = DatamapsDrawingHelper.getInstance();
    private int size = 0;
    private boolean fullLoad = false;

    public DataMapKeyChildFactory(String mapName) {
        this.mapName = mapName;
    }

    protected boolean createKeys(List toPopulate) {
        Integer numberForLoad = this.dmdh.getNumberForLoad(this.mapName);
        if (numberForLoad == 1) {
            try {
                int size = this.apiService.getDataMapKeysWithLastUpdatedForDataMap(this.mapName).size();
                if (size > 1000) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataMapKeyChildFactory.class, (String)"DataMapKeyChildFactory.fullLoadDescriptor.message"), NbBundle.getMessage(DataMapKeyChildFactory.class, (String)"DataMapKeyChildFactory.fullLoadDescriptor.title"), 0);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
                                DataMapKeyChildFactory.this.fullLoad = true;
                            }
                        }
                    });
                } else {
                    this.fullLoad = true;
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            List keyList = this.apiService.getDataMapKeysWithLastUpdatedForDataMap(this.mapName);
            keyList.sort(new Comparator<DataMapValue>(){

                @Override
                public int compare(DataMapValue o1, DataMapValue o2) {
                    String o1Key = o1.getKey() == null ? "-" : o1.getKey();
                    String o2Key = o2.getKey() == null ? "-" : o2.getKey();
                    return String.CASE_INSENSITIVE_ORDER.compare(o1Key, o2Key);
                }
            });
            if (this.fullLoad) {
                keyList.stream().map(s -> new DataMapKey(this.mapName, (DataMapValue)s)).forEach(k -> toPopulate.add(k));
            } else {
                this.size = 1000 * numberForLoad > keyList.size() ? keyList.size() : 1000 * numberForLoad;
                for (int i = 0; i < this.size; ++i) {
                    DataMapKey dmk = new DataMapKey(this.mapName, (DataMapValue)keyList.get(i));
                    toPopulate.add(dmk);
                }
                if (this.size == 1000 * numberForLoad) {
                    DataMapValue dmvNext = new DataMapValue();
                    String keyName = String.format(NbBundle.getMessage(DataMapKeyChildFactory.class, (String)"DataMapKeyChildFactory.nextNode.keyName"), this.size);
                    dmvNext.setKey(keyName);
                    dmvNext.setLastUpdated(System.currentTimeMillis() + 86400L);
                    dmvNext.setMap(this.mapName);
                    DataMapKey dmkNext = new DataMapKey(this.mapName, dmvNext);
                    toPopulate.add(dmkNext);
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(DataMapKey key) {
        return new DataMapKeyNode(key, this.fullLoad, this.size);
    }
}

