/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdate;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateTableModel;

public class ScriptUpdateTableRenderer
extends JLabel
implements TableCellRenderer {
    private ScriptUpdateTableModel model = null;

    public ScriptUpdateTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.model == null) {
            this.model = (ScriptUpdateTableModel)table.getModel();
        }
        if (value == null) {
            return this;
        }
        ScriptUpdate script = (ScriptUpdate)value;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.colorByStatus(script, table);
            this.colorByEnabled(script, table);
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        if (this.model.getChangedScripts().containsKey(script.getId())) {
            this.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.setText(script.getName());
        return this;
    }

    private void colorByEnabled(ScriptUpdate script, JTable table) {
        if (script.isEnabled()) {
            this.setForeground(table.getForeground());
        } else {
            this.setForeground(UIManager.getColor("MenuItem.disabledForeground"));
        }
    }

    private void colorByStatus(ScriptUpdate script, JTable table) {
        switch (script.getChangeType()) {
            case GREEN: {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(new Color(152, 255, 102));
                this.setToolTipText(script.getName() + " exists only on centralized server");
                break;
            }
            case BLUE: {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(new Color(102, 152, 255));
                this.setToolTipText(script.getName() + " is different");
                break;
            }
            case YELLOW: {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(new Color(255, 249, 102));
                this.setToolTipText(script.getName() + " is missing hash");
                break;
            }
            case RED: {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(new Color(255, 134, 102));
                this.setToolTipText(script.getName() + " doesn't exists on centralized server");
            }
        }
    }
}

