/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import com.jme3.input.controls.ActionListener;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.SystemListener;
import java.awt.Canvas;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.core.module.visengine.VisualizationEngine;
import rs.co.ast.aspen.core.module.visengine.VisualizationException;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SelectedListener;
import rs.co.ast.aspen.gui.module.vis.threed.phys.FieldMatrix;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsConstants;
import rs.co.ast.aspen.gui.module.visualization.Config;
import rs.co.ast.aspen.gui.module.visualization.VisualizationConfiguration;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;
import rs.co.ast.aspen.gui.module.visualization.properties.NodeManager;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;
import rs.co.ast.aspen.gui.module.visualization.properties.SelectedListenerImpl;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationSettings;

public class VisualizationManager {
    private static final Logger LOGGER = Logger.getLogger(VisualizationManager.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private Renderer app;
    private final AppSettings appSettings = new AppSettings(true);
    private Config config;
    private NodeManager nodeManager;
    private Canvas oglCanvas;
    private final VisualizationSettings settings = new VisualizationSettings();
    private String scriptName;
    private JPanel panel;
    private VisualizationEngine visEngine;
    private SelectedListener clickListener;
    private final ActionListener keyboardSpaceListener = (name, isPressed, tpf) -> {
        if (!isPressed) {
            this.getNodeManager().unpauseConsumer();
            this.changeMode(Producer.Mode.STEPPING);
            try {
                this.nextStep();
            }
            catch (InterruptedException | VisualizationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    };
    private Script configScript;
    private VisualizationConfiguration visConfig;
    private Script visRuleSetScript;
    private Ruleset rs;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.settings.addPropertyChangeListener(listener);
    }

    public void changeMode(Producer.Mode mode) {
        this.nodeManager.changeMode(mode);
    }

    public Renderer getApp() {
        return this.app;
    }

    public Config getConfig() {
        return this.config;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Canvas getOglCanvas() {
        return this.oglCanvas;
    }

    public VisualizationSettings getSettings() {
        return this.settings;
    }

    public Config initConfig(String scriptName, boolean useRuleSetScriptFromCache) {
        try {
            this.scriptName = scriptName;
            this.settings.setScriptName(scriptName);
            this.configScript = this.settings.getScriptByName(scriptName);
            this.visConfig = VisualizationConfiguration.configFromJson(this.configScript.getScript());
            RendererProperties rendererProps = this.visConfig.getRendererProperties();
            PhysicsConstants physicsConstants = this.visConfig.getPhysicsConstants();
            FieldMatrix fieldMatrix = this.visConfig.getFieldMatrix();
            if (this.visRuleSetScript == null || !useRuleSetScriptFromCache) {
                this.visRuleSetScript = this.apiService.getVisualizationRuleSetByName(this.visConfig.RULESET);
            }
            this.rs = Ruleset.fromJson((String)this.visRuleSetScript.getScript());
            this.visEngine = new VisualizationEngine(this.rs);
            this.config = new Config(this.visConfig, rendererProps, physicsConstants, fieldMatrix, this.visRuleSetScript, this.rs, this.visEngine);
            return this.config;
        }
        catch (ScriptException ex) {
            LOGGER.log(Level.SEVERE, String.format("Script %s has errors!", scriptName), ex);
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(VisualizationTopComponent.class, (String)"VisualizationManager.script.error.title"), scriptName), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return null;
        }
        catch (ApiServiceException_Exception ex) {
            LOGGER.log(Level.SEVERE, String.format("Can not retrive %s script! Please check your connection.", scriptName), ex);
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(VisualizationTopComponent.class, (String)"VisualizationManager.get.script.error.title"), scriptName), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return null;
        }
    }

    public void initOrResetApp(JPanel panel, Config config, boolean applySettings, boolean realtime) throws InterruptedException, ExecutionException {
        this.panel = panel;
        this.nodeManager = NodeManager.getInstance(realtime);
        if (config != null) {
            if (applySettings) {
                this.nodeManager.updateStepDelay(this.settings.getStepDelay());
                this.nodeManager.updateEventsPerStep(this.settings.getEventsPerStep());
                this.nodeManager.updateStartDate(this.settings.getStartDate());
                this.nodeManager.updateFinishDate(this.settings.getFinishDate());
            } else {
                this.nodeManager.updateStepDelay(config.getVisConfig().SLEEP_TIME);
                this.settings.setStepDelay(config.getVisConfig().SLEEP_TIME);
                this.nodeManager.updateEventsPerStep(config.getVisConfig().NUMBER_OF_EVENTS);
                this.settings.setEventsPerStep(config.getVisConfig().NUMBER_OF_EVENTS);
                this.settings.setStartDate(System.currentTimeMillis() - 3600000L);
                this.settings.setFinishDate(System.currentTimeMillis());
                this.nodeManager.updateStartDate(this.settings.getStartDate());
                this.nodeManager.updateFinishDate(this.settings.getFinishDate());
            }
            if (this.app == null) {
                this.appSettings.setSamples(8);
                this.app = new Renderer(config.getRendererProps(), config.getVisConfig().DIMENSIONALITY.equalsIgnoreCase("2D") ? Renderer.SpatialMode._2D : Renderer.SpatialMode._3D, config.getPhysicsConstants(), config.getFieldMatrix());
                this.app.setPauseOnLostFocus(false);
                this.app.setDisplayFps(false);
                this.app.setDisplayStatView(false);
                this.clickListener = new SelectedListenerImpl(this.app, config);
                this.app.addSelectedListener(this.clickListener);
                this.app.addKeyboardListener(57, this.keyboardSpaceListener);
                this.app.setSettings(this.appSettings);
                this.app.createCanvas();
                JmeCanvasContext ctx = (JmeCanvasContext)this.app.getContext();
                ctx.setSystemListener((SystemListener)this.app);
                this.oglCanvas = ctx.getCanvas();
                panel.removeAll();
                panel.add(this.oglCanvas);
                LOGGER.log(Level.INFO, "Setting renderer resolution to {0}x{1}", new Object[]{panel.getWidth(), panel.getHeight()});
                this.appSettings.setResolution(panel.getWidth(), panel.getHeight());
                this.app.startCanvas();
            } else {
                LOGGER.log(Level.INFO, "Setting renderer resolution to {0}x{1}", new Object[]{panel.getWidth(), panel.getHeight()});
                this.appSettings.setResolution(panel.getWidth(), panel.getHeight());
                this.app.setSettings(this.appSettings);
                this.app.reset(config.getRendererProps(), config.getVisConfig().DIMENSIONALITY.equalsIgnoreCase("2D") ? Renderer.SpatialMode._2D : Renderer.SpatialMode._3D, config.getPhysicsConstants(), config.getFieldMatrix());
                if (this.clickListener == null) {
                    this.clickListener = new SelectedListenerImpl(this.app, config);
                }
                this.app.addSelectedListener(this.clickListener);
                this.app.addKeyboardListener(57, this.keyboardSpaceListener);
            }
        } else {
            LOGGER.severe(String.format("Configuration for %s script can not be null!", this.scriptName));
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(VisualizationTopComponent.class, (String)"VisualizationManager.script.configuration.error.title"), this.scriptName), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
    }

    public void nextStep() throws InterruptedException, VisualizationException {
        this.nodeManager.nextStep();
    }

    public void pause() throws InterruptedException, ExecutionException {
        this.pauseNodeWorker();
        this.pauseApp();
    }

    private void unpause() throws InterruptedException, ExecutionException {
        this.nodeManager.unpause();
        if (this.app != null) {
            Future f = this.app.enqueue(() -> {
                this.app.setPaused(false);
                return null;
            });
            f.get();
        }
    }

    public void pauseApp() throws InterruptedException, ExecutionException {
        if (this.app != null) {
            Future f = this.app.enqueue(() -> {
                this.app.setPaused(true);
                return null;
            });
            f.get();
        }
    }

    public void pauseNodeWorker() {
        if (this.nodeManager != null) {
            this.nodeManager.pause();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.settings.removePropertyChangeListener(listener);
    }

    public void reset() {
        Future f = this.app.enqueue(() -> {
            this.nodeManager.clearQueue();
            this.visEngine.reset();
            this.config = this.initConfig(this.scriptName, true);
            this.app.resetInEDT(this.config.getRendererProps(), this.config.getVisConfig().DIMENSIONALITY.equalsIgnoreCase("2D") ? Renderer.SpatialMode._2D : Renderer.SpatialMode._3D, this.config.getPhysicsConstants(), this.config.getFieldMatrix());
            SwingUtilities.invokeLater(() -> {
                if (this.app != null) {
                    if (this.clickListener == null) {
                        this.clickListener = new SelectedListenerImpl(this.app, this.config);
                    }
                    this.app.addSelectedListener(this.clickListener);
                    try {
                        this.app.addKeyboardListener(57, this.keyboardSpaceListener);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return null;
        });
        try {
            LOGGER.info("VM RESET");
            this.pause();
            f.get();
            this.unpause();
            LOGGER.info("VM RESET - DONE");
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(VisualizationManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void startNodeWorker() {
        if (this.nodeManager != null) {
            this.nodeManager.start();
        }
    }

    public void stopNodeWorker() {
        if (this.nodeManager != null) {
            this.nodeManager.stop();
        }
    }

    public void unpauseNodeWorker() {
        this.nodeManager.unpause();
    }

    public void pausePhysicsSimulation() {
        this.app.pausePhysicsSimulation();
    }

    public void unpausePhysicsSimulation() {
        this.app.unpausePhysicsSimulation();
    }

    public boolean isPhysicsSimulationPaused() {
        return this.app.isPhysicsSimulationPaused();
    }

    public void appStop() {
        this.app.stop();
        this.app = null;
    }

    public void applyResolution() {
        if (this.panel != null) {
            this.appSettings.setResolution(this.panel.getWidth(), this.panel.getHeight());
            this.app.setSettings(this.appSettings);
            this.app.restart();
        }
    }
}

