/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class VirtualizationSerializer {
    protected static final int CLASSLOADER_IDX_NOT_SET = -1;
    protected final Map<ClassLoader, Integer> classLoadersIndexes = new HashMap<ClassLoader, Integer>();
    protected final List<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();
    protected final Map<Class<?>, Integer> classIndexes = new HashMap();
    protected final List<Class<?>> classes = new ArrayList();

    protected static boolean isAncestorClassLoader(ClassLoader loader) {
        for (ClassLoader ancestor = JRAbstractLRUVirtualizer.class.getClassLoader(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(loader)) continue;
            return true;
        }
        return false;
    }

    public int getClassloaderIdx(Class<?> clazz) {
        int loaderIdx;
        ClassLoader classLoader = clazz.getClassLoader();
        if (clazz.isPrimitive() || classLoader == null || VirtualizationSerializer.isAncestorClassLoader(classLoader)) {
            loaderIdx = -1;
        } else {
            Integer idx = this.classLoadersIndexes.get(classLoader);
            if (idx == null) {
                idx = this.classLoadersList.size();
                this.classLoadersIndexes.put(classLoader, idx);
                this.classLoadersList.add(classLoader);
            }
            loaderIdx = idx;
        }
        return loaderIdx;
    }

    public Class<?> resolveClass(ObjectStreamClass desc, int loaderIdx) throws ClassNotFoundException {
        if (loaderIdx == -1) {
            return null;
        }
        ClassLoader loader = this.classLoadersList.get(loaderIdx);
        Class<?> clazz = Class.forName(desc.getName(), false, loader);
        return clazz;
    }

    public int getClassDescriptorIdx(Class<?> clazz) {
        Integer classIdx = this.classIndexes.get(clazz);
        if (classIdx == null) {
            classIdx = this.classIndexes.size();
            this.classIndexes.put(clazz, classIdx);
            this.classes.add(clazz);
        }
        return classIdx;
    }

    public Class<?> getClassForDescriptorIdx(int descriptorIdx) {
        return this.classes.get(descriptorIdx);
    }

    public final void writeData(JRVirtualizable o, OutputStream out) throws IOException {
        VirtualizationOutput oos = new VirtualizationOutput(out, this, o.getContext());
        Object virtualData = o.getVirtualData();
        oos.writeJRObject(virtualData);
        oos.flush();
    }

    public final void readData(JRVirtualizable o, InputStream in) throws IOException {
        VirtualizationInput ois = new VirtualizationInput(in, this, o.getContext());
        o.setVirtualData(ois.readJRObject());
    }
}

