/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXmlDataSource;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JRXmlDataSource
extends AbstractXmlDataSource<JRXmlDataSource> {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final JRXPathExecuter xPathExecuter;
    private InputStream inputStream;
    private boolean closeInputStream;

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, Document document) throws JRException {
        this(jasperReportsContext, document, ".");
    }

    public JRXmlDataSource(Document document) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), document);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.xPathExecuter = JRXPathExecuterUtils.getXPathExecuter(jasperReportsContext);
        this.moveFirst();
    }

    public JRXmlDataSource(Document document, String selectExpression) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), document, selectExpression);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, InputStream in) throws JRException {
        this(jasperReportsContext, in, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, InputStream in, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, in, ".", isNamespaceAware);
    }

    public JRXmlDataSource(InputStream in) throws JRException {
        this(in, false);
    }

    public JRXmlDataSource(InputStream in, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), in, isNamespaceAware);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, InputStream in, String selectExpression) throws JRException {
        this(jasperReportsContext, in, selectExpression, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, InputStream in, String selectExpression, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, JRXmlUtils.parse(new InputSource(in), isNamespaceAware), selectExpression);
        this.inputStream = in;
        this.closeInputStream = false;
    }

    public JRXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this(in, selectExpression, false);
    }

    public JRXmlDataSource(InputStream in, String selectExpression, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), in, selectExpression, isNamespaceAware);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, String uri) throws JRException {
        this(jasperReportsContext, uri, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, String uri, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, uri, ".", isNamespaceAware);
    }

    public JRXmlDataSource(String uri) throws JRException {
        this(uri, false);
    }

    public JRXmlDataSource(String uri, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), uri, isNamespaceAware);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, String uri, String selectExpression) throws JRException {
        this(jasperReportsContext, uri, selectExpression, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, String uri, String selectExpression, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(uri), selectExpression, isNamespaceAware);
        this.closeInputStream = true;
    }

    public JRXmlDataSource(String uri, String selectExpression) throws JRException {
        this(uri, selectExpression, false);
    }

    public JRXmlDataSource(String uri, String selectExpression, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), uri, selectExpression, isNamespaceAware);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, File file) throws JRException {
        this(jasperReportsContext, file, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, File file, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, file, ".", isNamespaceAware);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, false);
    }

    public JRXmlDataSource(File file, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file, isNamespaceAware);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, File file, String selectExpression) throws JRException {
        this(jasperReportsContext, file, selectExpression, false);
    }

    public JRXmlDataSource(JasperReportsContext jasperReportsContext, File file, String selectExpression, boolean isNamespaceAware) throws JRException {
        this(jasperReportsContext, JRXmlUtils.parse(file, isNamespaceAware), selectExpression);
    }

    public JRXmlDataSource(File file, String selectExpression) throws JRException {
        this(file, selectExpression, false);
    }

    public JRXmlDataSource(File file, String selectExpression, boolean isNamespaceAware) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file, selectExpression, isNamespaceAware);
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("data.common.xml.null.document", (Object[])null);
        }
        if (this.selectExpression == null) {
            throw new JRException("data.common.xml.null.select.expression", (Object[])null);
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList(this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    @Override
    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public Object getSelectObject(Node currentNode, String expression) throws JRException {
        return this.xPathExecuter.selectObject(currentNode, expression);
    }

    @Override
    public JRXmlDataSource subDataSource(String selectExpr) throws JRException {
        Document doc = this.subDocument();
        JRXmlDataSource subDataSource = new JRXmlDataSource(doc, selectExpr);
        subDataSource.setTextAttributes(this);
        return subDataSource;
    }

    @Override
    public JRXmlDataSource subDataSource() throws JRException {
        return (JRXmlDataSource)super.subDataSource();
    }

    @Override
    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("data.common.xml.node.not.available", (Object[])null);
        }
        return JRXmlUtils.createDocument(this.currentNode);
    }

    @Override
    public JRXmlDataSource dataSource(String selectExpr) throws JRException {
        JRXmlDataSource subDataSource = new JRXmlDataSource(this.document, selectExpr);
        subDataSource.setTextAttributes(this);
        return subDataSource;
    }

    @Override
    public JRXmlDataSource dataSource() throws JRException {
        return (JRXmlDataSource)super.dataSource();
    }

    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

